# Nombre de subexpressions amb avaluació igual al paràmetre

**INTRODUCCIÓ:**

En aquest exercici considerarem arbres que representen expressions sobre
els operadors `+,-,*`, i sobre operands naturals. Per exemple, el
següent arbre representa l'expressió `3+4*2-5`.

              -
              |
          ---- ----
         |         |
         +         5
         |
     ---- ----
    |         |
    3         *
              |
          ---- ----
         |         |
         4         2

**EXERCICI:**

Implementeu una funció que, donat un arbre binari `t` d'strings que
representa una expressió correcta sobre naturals i operadors `+,-,*`, i
un paràmetre enter `x`, retorna quantes subexpressions de `t` s'avaluen
a `x`. Aquesta és la capcelera:

    // Pre:  t és un arbre no buit que representa una expressió correcta
    //       sobre els naturals i els operadors +,-,*.
    //       Les operacions no produeixen errors d'overflow.
    // Post: Retorna el nombre de subarbres de t que s'avaluen a x.
    int numberSubtreesEvaluateToParam(BinTree<string> t, int x);

Aquí tenim un exemple de paràmetres d'entrada de la funció i la
corresponent sortida:

    numberSubtreesEvaluateToParam(             *             , 3) = 3
                                               |
                                        ------- -------
                                       |               |
                                       +               -
                                       |               |
                                   ---- ----       ---- ----
                                  |         |     |         |
                                  1         2     6         3

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`main.cc, BinaryTree.hh, numberSubtreesEvaluateToParam.hh, utils.hh, utils.cc`.
Us falta crear el fitxer `numberSubtreesEvaluateToParam.cc` amb els
corresponents `includes` i implementar-hi la funció anterior. Valdrà la
pena que utilitzeu algunes de les funcions oferides a `utils.hh`. Només
cal que pugeu `numberSubtreesEvaluateToParam.cc` al jutge.

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas consisteix en una descripció d'un arbre
binari que representa una expressió, i un enter. Fixeu-vos en que el
programa que us oferim ja s'encarrega de llegir aquestes entrades. Només
cal que implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent nombre de subarbres que
s'avaluen a l'enter donat. Fixeu-vos en que el programa que us oferim ja
s'encarrega d'escriure aquest nombre. Només cal que implementeu la
funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema.
Possiblement necessitareu alguna funció auxiliar per a obtenir una
solució eficient.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T16:55:12.662Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
