# Planificación de professores y asignaturas

La entrada de este ejercicio tendrá una o más lineas, donde cada una
especifica una clase que se imparte durante la semana. Más
concretamente, una linea tiene un nombre de asignatura, un nombre de
profesor, un dia de la semana, una hora de inicio y una hora de final.
Por ejemplo:

    algebra joel monday 8 10
    physics guille thursday 10 14
    programming guille thursday 11 13
    programming nuria thursday 12 14
    statistics silvia tuesday 9 10
    deeplearning silvia tuesday 8 10

Para simplificar, los nombres de asignaturas y profesores son strings de
letras minúsculas. Los dias de la semana siempre son uno de
`{monday,tuesday,wednesday,thursday,friday}`. Las dos horas $h_1,h_2$
siempre cumplen $h_1<h_2$ i están en el conjunto $\{0,\ldots,24\}$.

Como podéis ver en el ejemplo anterior, puede haber repeticiones de
asignatura y conflictos de profesores (una asignatura se puede estar
dando más de una vez simultaneamente, y un profesor puede estar asignado
a más de una clase simultaneamente).

La primera parte de la salida tendrá una descripción en forma de tabla
de cuantas clases se dan en cada hora de la semana. La primera columna
(`h`) tiene anchura 2 y es para describir la hora de inicio. Las
siguientes 5 columnas tienen anchura 10 cada una y son para cada dia de
la semana. Todas las columnas están justificadas a la derecha. Cada fila
muestra la información de una hora en concreto. Solo se muestran horas
desde la primera en que comienza alguna clase hasta la última en la que
todavía se estará dando alguna clase. Este sería el resultado
correspondiente al ejemplo anterior:

    number of subjects per slot:
     h    monday   tuesday wednesday  thursday    friday
     8         1         1         0         0         0
     9         1         2         0         0         0
    10         0         0         0         1         0
    11         0         0         0         2         0
    12         0         0         0         3         0
    13         0         0         0         2         0

En una segunda parte de la salida tenemos una tabla con el mismo
formato, pero ahora cada celda muestra el número de profesores
**diferentes** que están impartiendo clase durante aquella hora y dia
(es decir, el número de profesores que imparten durante aquella hora y
dia después de haber eliminado repeticiones). Este sería el resultado
correspondiente al ejemplo anterior:

    number of teachers per slot:
     h    monday   tuesday wednesday  thursday    friday
     8         1         1         0         0         0
     9         1         1         0         0         0
    10         0         0         0         1         0
    11         0         0         0         1         0
    12         0         0         0         2         0
    13         0         0         0         2         0

Finalmente, la salida tiene un natural, que es el mínimo número de horas
de clase donde necesitamos reemplazar al profesor actual por algún
profesor nuevo con el fin de que no hayan conflictos, es decir, para
conseguir que ningún profesor esté impartiendo dos clases
simultaneamente. Este sería el resultado correspondiente al ejemplo
anterior:

    number of replacements needed to avoid conflicts:
    3

Para resolver este ejercicio, es obligatorio que uséis convenientemente
las siguientes estructuras de datos. En caso contrario, se invalidará la
entrega.

    struct Slot {
    	vector<string> listsubjects;
    	vector<string> listteachers;
    };

    typedef vector<vector<Slot> > TableSlots;

## Entrada

La entrada ya se ha descrito en el propio enunciado del problema. Hechad
una ojeada a los juegos de pruebas públicos para terminar de ver los
detalles.

## Salida

La salida ya se ha descrito en el propio enunciado del problema. Hechad
una ojeada a los juegos de pruebas públicos para terminar de ver los
detalles.

## Observación

Evaluación sobre 10 puntos:

- Solución lenta: 5 puntos.

- Solución rápida: 10 puntos.

Entendemos como solución rápida una que es correcta, de coste $n\log(n)$
y capaz de superar los juegos de pruebas públicos y privados. Entendemos
como solución lenta una que no es rápida, pero es correcta y capaz de
superar los juegos de pruebas públicos.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T22:44:03.383Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
