# Schedule of teachers and subjects

The input of this exercise will have one or more lines, where each one
of them specifies a class given by a teacher along the week. More
specifically, each line has a name of a subject, a name of a teacher, a
day of the week, a starting hour and an ending hour. For example:

    algebra joel monday 8 10
    physics guille thursday 10 14
    programming guille thursday 11 13
    programming nuria thursday 12 14
    statistics silvia tuesday 9 10
    deeplearning silvia tuesday 8 10

For the sake of simplicity, names of subjects and teachers are strings
of lowercase letters. The days of the week are always in
`{monday,tuesday,wednesday,thursday,friday}`. The two hours $h_1,h_2$
always hold $h_1<h_2$ and are in the set $\{0,\ldots,24\}$.

As you can see on former example, there may be repetitions of subjects
and conflicts of teachers (a subject may be given simultaneously more
than once, and a teacher may be assigned to more than one simultaneous
class).

The first part of the output will have a description as a table of how
many classes are being given at each hour of the week. The first column
(`h`) has width 2 and is used to describe the starting time. The
following 5 columns have width 10 each and are used for each day of the
week. All columns are right-justified. Each row shows the information of
a concrete hour. The hours shown are only those in the interval starting
from the first one where a class is given until the last one where a
class is still being given. This would be the result corresponding to
former example:

    number of subjects per slot:
     h    monday   tuesday wednesday  thursday    friday
     8         1         1         0         0         0
     9         1         2         0         0         0
    10         0         0         0         1         0
    11         0         0         0         2         0
    12         0         0         0         3         0
    13         0         0         0         2         0

In a second part of the output we have a table with the same format, but
this time each cell shows the number of `different` teachers giving
class at that particular hour and day (that is, the number of teachers
giving class that hour and day after having removed repetitions). This
would be the result corresponding to former example:

    number of teachers per slot:
     h    monday   tuesday wednesday  thursday    friday
     8         1         1         0         0         0
     9         1         1         0         0         0
    10         0         0         0         1         0
    11         0         0         0         1         0
    12         0         0         0         2         0
    13         0         0         0         2         0

Finally, the output has a natural, which is the minimum number of hours
of class where we need to replace current professor with a new one in
order to avoid conflicts, that is, in order to prevent any teacher from
being giving two classes simultaneously. This would be the result
corresponding to former example:

    number of replacements needed to avoid conflicts:
    3

In order to solve this exercise, it is compulsory to conveniently use
the following data structures. Otherwise, the delivery will be
invalidated.

    struct Slot {
    	vector<string> listsubjects;
    	vector<string> listteachers;
    };

    typedef vector<vector<Slot> > TableSlots;

## Input

The input has already been described in the statement of the exercise.
Take a look at the public data tests in order to get the hang of it.

## Output

The output has already been described in the statement of the exercise.
Take a look at the public data tests in order to get the hang of it.

## Observation

Grading up to 10 points:

- Slow solution: 5 points.

- Fast solution: 10 points.

We understand as a fast solution one which is correct, with $n\log(n)$
cost and which passes the public and private tests. We understand as
slow solution one which is not fast, but it is correct and passes the
public tests.

## Problem information

Author: PRO1

Generation: 2026-01-25T22:43:59.062Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
