# Planificació de professors i assignatures

L'entrada d'aquest exercici tindrá una o més línies, on cadascuna
especifica una classe que s'imparteix durant la setmana. Més
concretament, una línia té un nom d'assignatura, un nom de professor, un
dia de la setmana, una hora d'inici i una hora de final. Per exemple:

    algebra joel monday 8 10
    physics guille thursday 10 14
    programming guille thursday 11 13
    programming nuria thursday 12 14
    statistics silvia tuesday 9 10
    deeplearning silvia tuesday 8 10

Per simplificar, els noms d'assignatures i professors son strings de
lletres minúscules. Els dies de la setmana sempre son un de
`{monday,tuesday,wednesday,thursday,friday}`. Les dues hores $h_1,h_2$
sempre cumpleixen $h_1<h_2$ i estan en el conjunt $\{0,\ldots,24\}$.

Com podeu veure en l'exemple anterior, hi pot haver repeticions
d'assignatura i conflictes de professors (una assignatura es pot estar
donant simultàniament més d'un cop alhora, i un professor pot estar
assignat a més d'una classe simultàniament).

La primera part de la sortida tindrá una descripció en forma de taula de
quantes classes es donen en cada hora de la setmana. La primera columna
(`h`) té amplada 2 i és per descriure la hora d'inici. Les següents 5
columnes tenen amplada 10 cadascuna i son per cada dia de la setmana.
Totes les columnes estan justificades a la dreta. Cada fila mostra la
informació d'una hora en concret. Només es mostren hores des de la
primera en la que comença alguna classe fins la última en la que encara
s'estarà donant alguna classe. Aquest seria el resultat corresponent a
l'exemple anterior:

    number of subjects per slot:
     h    monday   tuesday wednesday  thursday    friday
     8         1         1         0         0         0
     9         1         2         0         0         0
    10         0         0         0         1         0
    11         0         0         0         2         0
    12         0         0         0         3         0
    13         0         0         0         2         0

En una segona part de la sortida tenim una taula amb el mateix format,
però ara cada cel.la mostra el nombre de professors **diferents** que
estan impartint classe durant aquella hora i dia (és a dir, el nombre de
professors que imparteixen durant aquella hora i dia després d'haver
eliminat repeticions). Aquest seria el resultat corresponent a l'exemple
anterior:

    number of teachers per slot:
     h    monday   tuesday wednesday  thursday    friday
     8         1         1         0         0         0
     9         1         1         0         0         0
    10         0         0         0         1         0
    11         0         0         0         1         0
    12         0         0         0         2         0
    13         0         0         0         2         0

Finalment, la sortida té un natural, que és el mínim nombre d'hores de
classe a on necessitem reemplaçar el professor actual per algun
professor nou a fi que no hi hagin conflictes, és a dir, a fi
d'aconseguir que cap professor estigui impartint dos classes
simultàniament. Aquest seria el resultat corresponent a l'exemple
anterior:

    number of replacements needed to avoid conflicts:
    3

Per a resoldre aquest exercici, és obligatori que utilitzeu
convenientment les següents estructures de dades. En cas contrari,
s'invalidarà l'entrega.

    struct Slot {
    	vector<string> listsubjects;
    	vector<string> listteachers;
    };

    typedef vector<vector<Slot> > TableSlots;

## Entrada

L'entrada ja s'ha descrit en el propi enunciat del problema. Feu una
ullada als jocs de proves públics per tal d'acabar de veure'n els
detalls.

## Sortida

La sortida ja s'ha descrit en el propi enunciat del problema. Feu una
ullada als jocs de proves públics per tal d'acabar de veure'n els
detalls.

## Observació

Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost $n\log(n)$ i
capaç de superar els jocs de proves públics i privats. Entenem com a
solució lenta una que no és ràpida, però és correcta i capaç de superar
els jocs de proves públics.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T22:44:07.445Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
