# Avaluar expressions sense variables

**INTRODUCCIÓ:**

En aquest exercici considerarem arbres que representen expressions sobre
els operadors `+,-,*`, i sobre operands naturals. Per exemple, el
següent arbre representa l'expressió `3+4*2-5`.

              -
              |
          ---- ----
         |         |
         +         5
         |
     ---- ----
    |         |
    3         *
              |
          ---- ----
         |         |
         4         2

**EXERCICI:**

Implementeu una funció que, donat un arbre binari d'strings que
representa una expressió correcta sobre naturals i operadors `+,-,*`,
retorna la seva avaluació. Aquesta és la capcelera:

    // Pre:  t és un arbre no buit que representa una expressió correcta
    //       sobre els naturals i els operadors +,-,*.
    //       Les operacions no produeixen errors d'overflow.
    // Post: Retorna l'avaluació de l'expressió representada per t.
    int evaluate(const BinaryTree<string> &t);

Aquí tenim un exemple de paràmetre d'entrada de la funció i la
corresponent sortida:

    t=           *
                 |
          ------- -------
         |               |
         +               -
         |               |
     ---- ----       ---- ----
    |         |     |         |
    1         2     5         3

    =>

    6

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`Makefile, program.cpp, BinaryTree.hpp, evaluate.hpp, utils.hpp, utils.cpp`.
Us falta crear el fitxer `evaluate.cpp` amb els corresponents `includes`
i implementar-hi la funció anterior. Valdrà la pena que utilitzeu
algunes de les funcions oferides a `utils.hpp`. Quan pugeu la vostra
solució al jutge, només cal que pugeu un `tar` construït així:

    tar cf solution.tar evaluate.cpp

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas consisteix en una descripció d'un arbre
binari d'strings que representa una expressió correcta amb operadors de
suma, resta i multiplicació, i operands naturals. Fixeu-vos en que el
programa que us oferim ja s'encarrega de llegir aquestes entrades. Només
cal que implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté la corresponent avaluació de l'arbre.
Fixeu-vos en que el programa que us oferim ja s'encarrega d'escriure
aquesta avaluació. Només cal que implementeu la funció abans esmentada.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T21:30:44.505Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
