# Control PRO2 - Torn 2 (tardor 2015)

He vist al laboratori una versió de la classe `Cjt_estudiants` que
inclou una operació `estudiant_nota_max` per obtenir l'estudiant amb
millor nota. Hem decidit estendre aquesta classe amb una nova
funcionalitat: eliminar tots els estudiants sense nota. Hem optat per
afegir una nova operació pública amb la següent especificació:

    void eliminar_estudiants_sense_nota();
    /* Pre: cert */
    /* Post: el paràmetre implicit no conté cap estudiant sense nota */ 

Això ha suposat afegir un atribut nou a la classe. Tenint això en
compte, només heu d'implementar eficientment l'operació
`eliminar_estudiants_sense_nota` i l'operació:

    void afegir_estudiant(const Estudiant &est, bool& b);
    /* Pre: el paràmetre implícit no està ple */
    /* Post: b = indica si el p.i. original conté un estudiant amb el dni d'est;
       si b = fals, s'ha afegit l'estudiant est al paràmetre implícit */

## Observació

Heu de lliurar un fitxer `solucio.cc` amb una implementació eficient de
les operacions `afegir_estudiant` i `eliminar_estudiants_sense_nota` que
ha de tenir el següent format:

    #include "Cjt_estudiants.hh"

    void Cjt_estudiants::afegir_estudiant(const Estudiant &est, bool& b)
    {
      ... // codi de la implementació
    }

    void Cjt_estudiants::eliminar_estudiants_sense_nota()
    {
      ... // codi de la implementació
    }

Copieu aquesta plantilla en el vostre `solucio.cc` i completeu-la. El
vostre `solucio.cc` no pot contenir la implementació d'altres operacions
de la classe.

A l'apartat *Public files* del Jutge us proveïm amb material addicional
comprimit en un fitxer .tar. Podeu descomprimir aquest fitxer amb la
comanda

       tar -xvf nom_fitxer.tar

Aquest material addicional consisteix en els següents fitxers:

- `Cjt_estudiants.hh`: l'especificació Pre/Post de totes les operacions
  públiques i privades d'aquesta nova versió de la classe
  `Cjt_estudiants`, així como la definició dels camps privats. Fixeu-vos
  que un dels atributs és un enter `imax`, que conté la posició en el
  vector de l'estudiant amb millor nota o un -1 si el conjunt no té cap
  estudiant amb nota. Aquest atribut ens han permès implementar amb la
  màxima eficiència l'operació `estudiant_nota_max` i cal actualitzar-lo
  en les operacions modificadores de la classe. **És molt important que
  la implementació de les operacions que us hem encarregat tingui en
  compte i preservi l'invariant de la representació de la classe
  `Cjt_estudiants`**.

- `Cjt_estudiants.cc`: la implementació de totes de les operacions de la
  nova versió de la classe `Cjt_estudiants` tret de les operacions
  `afegir_estudiant` i `eliminar_estudiants_sense_nota`.

- `Estudiant.hh`: l'especificació de la classe `Estudiant` i la
  definició dels seus atributs. No presenta cap novetat, tret d'una
  operació addicional, `comp`, que permet comparar dos estudiants.

- `Estudiant.cc`: la implementació dels mètodes de la classe
  `Estudiant`.

- `pro2.cc`: un programa principal que podeu fer servir per provar les
  operacions públiques d'aquesta versió de la classe `Cjt_estudiants`.

- `llegeixme.txt`: instruccions per a generar l'executable del programa
  `pro2` i provar-lo.

Valorarem positivament que la solució no contingui instruccions
(especialment bucles o crides a operacions costoses) ni objectes
(especialment vectors o conjunts) innecessaris. No es pot emprar cap
estructura de dades que no hagi aparegut a les sessions 1-4 de
laboratori.\
 \
Quan feu els enviaments el Jutge us indicarà quants jocs de proves
passeu i de quin tipus (public o privat). El joc de proves anomenat
`public` s'explica al fitxer `llegeixme.txt`. El `privat1` és molt
semblant al `public`. Els `privat2` i `privat3` proven situacions
especials.

## Informació del problema

Autoria: Professors de PRO2

Generació: 2026-01-25T16:49:22.446Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
