# Grau màxim d'un arbre general

Donada la classe $Arbre$ que permet gestionar arbres generals usant
memòria dinàmica, cal implementar el mètode

      nat grau_max() const;

que retorna el grau màxim de tots els nodes de l'arbre.

Cal enviar a jutge.org la següent especificació de la classe $Arbre$ i
la implementació del mètode dins del mateix fitxer. Indica dins d'un
comentari a la capçalera del mètode el seu cost en funció del nombre
d'elements $n$ de l'arbre.

    #include <algorithm>
    #include <cstddef>
    using namespace std;
    typedef unsigned int nat;

    template <typename T>
    class Arbre {

    public:
      // Construeix un Arbre format per un únic node que conté a x.
      Arbre(const T &x);

      // Tres grans.
      Arbre(const Arbre<T> &a);
      Arbre& operator=(const Arbre<T> &a);
      ~Arbre() throw();

      // Col·loca l'Arbre donat com a primer fill de l'arrel de l'arbre sobre el que s'aplica el mètode i l'arbre a queda invalidat; després de fer b.afegir\_fill(a), a no és un arbre vàlid.
      void afegir_fill(Arbre<T> &a);

      static const int ArbreInvalid = 400;

      // Retorna grau màxim dels nodes de l'arbre
      nat grau_max() const;

    private:
      Arbre(): _arrel(NULL) {};
      struct node {
        T info;
        node* primf;
        node* seggerm;
      };
      node* _arrel;
      static node* copia_arbre(node* p);
      static void destrueix_arbre(node* p) throw();

      // Aquí va l'especificació dels mètodes privats addicionals
    };

    // Aquí va la implementació del mètode grau\_max

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $Arbre$ i un programa principal que llegeix un
arbre general i desprès crida el mètode $grau\_max$.

## Entrada

L'entrada consisteix en la descripció d'un arbre general d'enters (el
seu recorregut en preordre, en el qual al valor de cada node li segueix
el seu nombre de fills).

## Sortida

Una línia amb el grau màxim de l'arbre general.

## Observació

Només cal enviar la classe requerida i la implementació del mètode
$grau\_max$ amb el seu cost en funció del nombre d'elements $n$ de
l'arbre. Pots ampliar la classe amb mètodes privats. Segueix
estrictament la definició de la classe de l'enunciat.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T16:48:56.093Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
