#ifndef PALABRA_HPP
#define PALABRA_HPP

#include "utils.PRO2"
#include <vector>

class Palabra{

// Tipo de mdulo: datos 
// Descripcin del tipo: una secuencia indexada de caracteres, escogidos entre
// a..z, A..Z y 0..9. El resto son considerados separadores de cara a la 
// lectura, salvo el '.', que se usar para distinguir la palabra final, 
// o marca,  de un texto. Para ello, el '.' ha de leerse separado de la 
// palabra anterior. La longitud de la secuencia est acotada por la 
// implementacin

private:

  static const int MAXLONG = 20;     // si queremos otra marca u otro MAXLONG
  static const char MARCAFINAL = '.';// solo hay que tocar estos campos 
                                      
  vector<char> letras;
  int longitud;

public:

  // Constructoras

  Palabra ();
  /* Pre: cert */ 
  /* Post: el resultado es una palabra sin caracteres y longitud 0 */
 
  Palabra (int cin);
  /* Pre: En el canal standard de entrada hay uno o ms caracteres a..z A..Z 
     0..9 o . */
  /* Post: El resultado contiene los caracteres vlidos ledos del canal 
     standard de entrada, hasta el primer separador posterior a stos */

  // Modificadoras 

  void anadir_letra (char c);
  /* Pre: c es un caracter a..z A..Z 0..9 o .;  la longitud del parametro 
     implcito es menor de la mxima permitida */
  /* Post: el parametro implcito queda como el original pero con c aadido 
     al final  */

  // Consultoras

  int longitud_maxima () const;
  /* Pre: cierto */ 
  /* Post: El resultado es la longitud mxima permitida por la implementacin */
 
  int long_pal () const;
  /* Pre: cierto */ 
  /* Post: El resultado es la longitud del parmetro implcito */
 
  char consultar_letra (int i) const;
  /* Pre: i est entre 1 y la longitud del parametro implcito */ 
  /* Post: El resultado es la letra i-sima del parametro implcito */

  bool marca () const;
  /* Pre: cierto */
  /* Post: El resultado indica si el parametro implcito es un '.' */

  bool iguales (const Palabra & p) const;
  /* Pre: cierto */
  /* Post: El resultado indica si p es igual al parametro implcito */

  // Lectura y escritura
 
  void leer_palabra ();
  /* Pre: En el canal standard de entrada hay uno o ms caracteres a..z A..Z 
     0..9 o . */
  /* Post: El parmetro implcito pasa a tener los caracteres vlidos ledos 
     del canal standard de entrada hasta el primer separador posterior a stos*/

  void escribir_palabra () const;
  /* Pre: cierto */
  /* Post: Se han escrito los caracteres del parmetro implcito en el canal
     standard de salida */
};
#endif
