# Examen de la práctica de PRO2 - Primavera 2020

El objetivo en este examen de la práctica será modificar dos de las
funcionalidades de tu solución de la práctica. Concretamente deberás
cambiar:

1.  el método utilizado para calcular la distancia entre dos especies

2.  el método para calcular distancias entre clústers a lo largo de la
    ejecución del algoritmo de clusterización que construye un árbol
    filogenético

IMPORTANTE: Este problema de Jutge es el único canal disponible para
realizar la entrega del examen de la práctica. Ten en cuenta que

- Dispondrás de 1h 45 min para la resolución del examen.

- La nota del examen procederá exclusivamente de la corrección
  automática de tu último envío.

- No superar ningún juego de pruebas conlleva un cero en la nota de este
  examen.

- Podrás realizar tantas entregas como quieras, pero solo se tendrá en
  cuenta la más reciente.

Las dos nuevas funcionalidades que has de implementar en este examen
están descritas con todo detalle en el documento `enunciado_examen.pdf`
que forma parte del archivo `public.tar` que puedes descargar en esta
página (icono del gatito).

## Observación

Recomendamos que hagas una copia "limpia" de tu práctica en un
subdirectorio aparte y en esa copia lleves a cabo todos los cambios.
Verifica que todos los módulos compilan sin errores, que el proceso de
montaje da un archivo ejecutable correcto y que el `program.exe` pasa el
juego de pruebas público suministrado. Comprueba que el `Makefile`
genera el fichero `program.exe` y crea el fichero `.tar` para hacer el
envío al Jutge. Asegúrate que entregas el fichero `.tar` con la solución
del examen, no la solución original.

El Jutge prueba tus entregas mediante 4 juegos de pruebas que, salvo por
el cambio del comando `#ejecuta_paso_wpgma` por el comando
`#ejecuta_paso_clust`, son similares a los usados en la práctica---de
hecho son casi iguales, solo algo menos "exigentes" respecto a la
eficiencia.

- sample: el juego de pruebas público

- privat1: solo distancias entre especies

- privat2: clusters 1

- privat3: clusters 2

En un fichero llamado `practica.tar` debes entregar

- Los ficheros `.hh` y `.cc` de las clases y el programa principal. No
  incluyas ficheros `.o` y similares.

- El fichero `Makefile`, que usaremos para generar y probar el
  ejecutable

Ten en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  ` program.cc` (recuerda cambiar la opción del `main` que realiza un
  paso del algoritmo de construcción del árbol filogenético, para que
  pase a llamarse `ejecuta_paso_clust`)

- El `Makefile` ha de generar un ejecutable llamado `program.exe`

- Es importante que uses las opciones de compilación del Jutge de PRO2
  (véase Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 en
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

Produce el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengas los ficheros que vas a
entregar. Incluye esta instrucción en tu Makefile, de forma que el
`.tar` se pueda generar ejecutando `make practica.tar`. Con eso
reduciras el riesgo de error en sucesivas entregas. El Jutge no acepta
`.tar` donde los ficheros estén dentro de carpetas. Recomendamos usar
`GNU tar` para reducir el riesgo de que el fichero `practica.tar` sea
incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

## Información del problema

Autoría: PRO2

Generación: 2026-01-25T21:30:01.124Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
