# TinyMicro program counter

Design the program counter of the TinyMicro. After reset, the program
counter must have the value zero. The value will be modified at each
cycle the counter is enabled. If signal `jump` is asserted, the program
counter will be loaded with `jump_address`, otherwise it will be
increased by one.

The number of bits of the program counter must be a parameter (`N`) with
the default value shown in the specification.

## Specification

``` verilog
module program_counter(pc, jump_address, enable, jump, clk, rst);
    parameter N=6;
    output [N-1:0] pc;
    input [N-1:0] jump_address;
    input enable, jump, clk, rst;
```

## Input

- `enable` is the signal the enables the change of the program counter
  value.

- `jump` is the signal that indicates that the program counter must be
  loaded with a new address.

- `jump_address` is the new value that must be stored in the program
  counter whem `jump` is asserted.

- `clk` is the clock signal of the circuit.

- `rst` is the reset signal of the circuit.

## Output

- `pc` is the value of the program counter.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:25:44.503Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
