# Sistemes monetaris canònics (2)

Gairebé tots els sistemes de monedes que es fan servir són *canònics*:
això vol dir que l'algoritme *greedy* per assolir una quantitat, és a
dir, fer servir cada vegada la més alta denominació possible,
proporciona sempre el mínim nombre de monedes.

Dòlars, euros, i els sistemes europeus abans de l'euro com ara pessetes
o *gulden* holandesos, tenen aquesta propietat. Tanmateix, no sempre és
així. Les lliures esterlines d'UK, abans del canvi fet el 15 de febrer
de 1971, estaven molt lluny de ser un sistema canònic (veure
`https://en.wikipedia.org/wiki/Decimal_Day`). Com a exemple senzill, amb
monedes d'1 unitat, 5 unitats i 8 unitats, l'estratègia *greedy* *no*
condueix a una configuració òptima per sumar 15 unitats: hi tria primer
8, llavors 5, i li calen dos 1's, quan amb tres 5's hi ha prou; diem que
aquest valor 15 és un *contraexemple* a la canonicitat del sistema.

El 1993, Dexter Kozen and Shmuel Zaks van provar matemàticament que, si
un sistema no és canònic, aleshores hi ha un contraexemple per sota de
la suma de les dues denominacions més altes del sistema. Amb això,
podràs distingir sistemes canònics (encara que posteriorment s'han
trobat algoritmes més eficients).

## Entrada

El programa rebrà primer un enter no negatiu $n$ indicant quants casos
hi ha. Desprès hi haurà $n$ casos. Cada cas comença amb $m$, un enter
positiu que diu quantes denominacions diferentes de monedes té el
sistema, seguit de les denominacions: $m$ enters positius ordenats
ascendentment i on la denominació més petita sempre serà 1 (altrament,
la quantitat 1 no es pot assolir).

## Sortida

Per cada cas, el programa ha d'escriure una línia. Si el cas és un
sistema canònic, escriu les denominacions del cas en ordre ascendent
seguides de les paraules \"is canonical\". Si no ho és, escriu el
contraexemple més petit, les paraules \"proves that\", les denominacions
del cas en ordre ascendent, i les paraules \"is not canonical\".

## Observació

Solucions poc eficients tindran poques possibilitats de ser acceptades
ací. A l'exercici \"germà\" X24976, que demana resoldre el mateix
poblema, la solució de referència és més lenta i solucions relativament
lentes poden resultar acceptades enllà.

## Informació del problema

Autoria: José Luis Balcázar

Generació: 2026-01-25T16:42:34.574Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
