# Template

A **transposition** of a deck of cards is the following sequence of
operations:

- Throw away an arbitrary number of cards from the top of the deck (it
  is allowed to throw away no cards, or to throw away all cards);

- Pick a number $k \in \{2, 3\}$;

- Divide the remaining part of the deck into $k$ parts. Part number $t$
  ($0 \leq t < k$) consists of cards which have been in positions $i$
  such that $i \bmod k = t$. In each part, cards are arranged in the
  same way as they were arranged in the original deck.

- Transpose each of the $k$ parts. We can transpose the parts in any
  order, but we can start transposing the next part only after
  completely transposing the previous one (for example, if $A$ is split
  into $B$ and $C$, then we transpose $B$ and split it into $D$ and $E$,
  then we have to transpose both $D$ and $E$ (in any order) before
  proceeding to transposing $C$).

You are given a deck of cards with numbers. You can look at the cards,
so you know all numbers on all cards. Your task is to find a
transposition which gives the greatest amount of points. We get 1 point
whenever the sum of the cards thrown away so far is divisible by 100. If
two transpositions give the same score, the one in which the first card
thrown away has a lower value is better. If we still have a draw, the
second card decides, and so on.

## Input

The first line contains a single number $N$ --- how many cards there are
in the deck ($1 \leq N \leq 200$).

The $(i+1)$-th row, $1\leq i\leq N$, contains a single integer $k_i$,
which is the value of the $i$-th card ($-999 \leq k_i \leq 999$).

## Output

In the first row output the score (the number of points received). In
the second row output $c_1 c_2 c_3 \ldots c_N$, where $c_i$ is the
$i$-th card thrown away when using the optimal way of transposing the
deck.

## Problem information

Author: Eryk Kopczynski

Generation: 2026-01-25T22:37:37.784Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
