# Arbre general. Són els elements del nivell $n$-èssim una seqüència estrictament creixent?

Donada la classe $Arbre$ que permet gestionar arbres generals usant
memòria dinàmica, cal implementar el mètode

      bool nivell_n_creixent(int nivell_cercat);

que determina si els elements del $nivell\_ cercat$, llegits d'esquerra
a dreta, són una seqüència d'enters estrictament creixent. Considerem
que una seqüència buida és estrictament creixent.

Cal enviar a jutge.org la següent especificació de la classe $Arbre$ i
la implementació del mètode dins del mateix fitxer.

    #include <cstdlib>
    #include <iostream>
    using namespace std;
    typedef unsigned int nat;

    template <typename T>
    class Arbre {

    public:
      // Construeix un Arbre format per un únic node que conté a x.
      Arbre(const T &x);

      // Tres grans.
      Arbre(const Arbre<T> &a);
      Arbre& operator=(const Arbre<T> &a);
      ~Arbre() throw();

      // Col·loca l'arbre donat com a darrer fill de l'arrel de l'arbre sobre el que s'aplica el
      // mètode i l'arbre a queda invalidat.
      void afegir_darrer_fill(Arbre<T> &a);

      static const int ArbreInvalid = 400;

      // Comprova si els valors dels elements de nivell i llegits d'esquerra a dreta
      // formen una seqüència estrictament creixent
      bool nivell_n_creixent(int nivell_cercat);

    private:
      Arbre(): _arrel(NULL) {};
      struct node {
        T info;
        node* primf;
        node* seggerm;
      };
      node* _arrel;
      static node* copia_arbre(node* p);
      static void destrueix_arbre(node* p) throw();

      // Aquí va l'especificació dels mètodes privats addicionals
    };

    static const int minimum_int_ESIN = -2147483648;

    // Aquí va la implementació del mètode nivell\_n\_creixent i dels mètodes privats addicionals

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $Arbre$ i un programa principal que llegeix un
arbre general, el nivell cercat i crida el mètode $nivell\_n\_creixent$.

## Entrada

L'entrada consisteix en la descripció d'un arbre general d'enters (el
seu recorregut en preordre, en el qual al valor de cada node li segueix
el seu nombre de fills). A continuació segueix un enter que representa
el nivell cercat.

## Sortida

Una línia amb el text \"NO és estrictament creixent al nivell **X**\" si
es dóna el cas que els elements del nivell **X**, llegits d'esquerra a
dreta, no són una seqüència d'enters estrictament creixent. La sortida
serà, \"SI és estrictament creixent al nivell **X**\" altrament.

## Observació

Només cal enviar la classe requerida i la implementació del mètode
$nivell\_n\_creixent$. Pots ampliar la classe amb mètodes privats.
Segueix estrictament la definició de la classe de l'enunciat.

## Informació del problema

Autoria: Ignasi Gómez-Sebastià &amp; Jordi Esteve

Generació: 2026-01-25T16:35:56.242Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
