# Insertar sumes de prefixos en una llista (Pro2)

Heu d'implementar una funció que rep una llista d'enters
$[x_0,x_1,x_2,\ldots,x_{n-2},x_{n-1}]$ com a paràmetre per referència.
La funció haurà d'insertar, després de cada element, la suma de la
llista des del principi fins aquell element, és a dir, la funció retorna
la llista:
$$[x_0,\;x_0,\;x_1,\;x_0+x_1,\;x_2,\;x_0+x_1+x_2,\;\ldots,\;x_{n-2},\;x_0+\cdots+x_{n-2},\;x_{n-1},\;x_0+\cdots+x_ {n-1}]$$

**Important:** Heu de garantir que els elements que la llista contenia
inicialment queden inalterats i ocupant les posicions parells (indexant
des de 0). En particular, la funció no els pot eliminar i tornar a
afegir després.

Aquesta és la capcelera:

    // Pre: Sigui [x0,x1,x2,...,x{n-1}] el valor inicial de l.
    // Post: El valor de l és [x0, x0, x1, x0+x1 ,x2 ,x0+x1+x2 ,..., x{n-1}, x0+...+x{n-1}].
    //       A més a més, els elements inicials de la llista han persistit i
    //       no han canviat de valor, i ocupen les posicions parells (indexant des de 0).
    void insertSumsPrefixes(list<int> &l);

Aquí tenim un exemple de comportament de la funció:

    insertSumsPrefixes(L = [2,3,1]) => L = [2,2,3,5,1,6]

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar: `main.cc, insertSumsPrefixes.hh`. Us
falta crear el fitxer `insertSumsPrefixes.cc` amb els corresponents
`includes` i implementar-hi la funció anterior. Només cal que pugeu
`insertSumsPrefixes.cc` al jutge.

## Entrada

L'entrada té un nombre arbitrari de casos. Cada cas consisteix en una
llista d'enters en una línia. Fixeu-vos en que el programa que us oferim
ja s'encarrega de llegir aquestes entrades. Només cal que implementeu la
funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent resultat de la funció.
Fixeu-vos en que el programa que us oferim ja s'encarrega d'escriure
aquesta sortida. Només cal que implementeu la funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
llistes. Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost lineal i capaç
de superar els jocs de proves públics i privats. Entenem com a solució
lenta una que no és ràpida, però és correcta i capaç de superar els jocs
de proves públics.

Una solució que altera, o elimina els elements originals de la primera
llista i els torna a afegir més tard rebrà un 0.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T16:33:20.845Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
