# Vectors Incrustables

Siguin $A$ i $B$ dos vectors, i siguin $A_1$ i $A_2$ una partició
arbitrària d'$A$ tal que $A$ és la concatenació d'$A_1$ i $A_2$. La
**incrustació** de $B$ a dins d'$A$ és el vector que tenim un cop hem
concatenat $A_1$ amb $B$ i amb $A_2$. Per exemple, si A = $[1, 2, 3, 4]$
i $B = [6,7,8]$, una possible incrustació de $B$ a dins d'$A$ seria
$[1,2,6,7,8,3,4]$.

Òbviament, si `N = len(A)` llavors podem incrustar $B$ en $N + 1$
possibles posicions. Cal dir que els casos extrems consistirien en
incrustar $B$ abans d'$A$ o bé al final d'$A$.

Siguin $A$ i $B$ dos vectors **ordenats** d'enters, potser amb
repeticions i que poden tenir mides diferents. Diem que $A$ i $B$ són
**incrustables** si la incrustació de $B$ a dins d'$A$ és també un
vector ordenat. Per exemple, si tenim que:

:::: center
::: NoShortVerb
+:-------------------:+:------------------------:+
| A=                  | B =                      |
|                     |                          |
| ::: NoShortVerb     | ::: NoShortVerb          |
|    1   3   25   26  |    8   9   10   19   24  |
|   --- --- ---- ---- |   --- --- ---- ---- ---- |
| :::                 | :::                      |
+---------------------+--------------------------+
:::
::::

llavors $A$ i $B$ són incrustables, ja que si incrustem el vector $B$ a
la posició $3$ del vector $A$:

:::: center
::: NoShortVerb
   1   3   8   9   10   19   24   25   26
  --- --- --- --- ---- ---- ---- ---- ----
:::
::::

es manté ordenat. En canvi, si tenim:

:::: center
::: NoShortVerb
+:-------------------:+:--------------------:+
| A=                  | B =                  |
|                     |                      |
| ::: NoShortVerb     | ::: NoShortVerb      |
|    1   3   15   26  |    5   9   33        |
|   --- --- ---- ---- |   --- --- ---- -- -- |
| :::                 | :::                  |
+---------------------+----------------------+
:::
::::

$A$ i $B$ **no** són incrustables, ja que no hi ha cap manera
d'incrustar $B$ a dins d'$A$ de manera que ens doni un vector ordenat.

Feu la funció `incrustables(A,B)` tal que, donats un parell de vectors
d'enters ordenats `A,B`, retorni `TRUE` si i només si $B$ és incrustable
a $A$.

IMPORTANT: Per a fer aquest problema, tingueu en compte que **no cal**
crear els vectors incrustats.

## Entrada

Dos vectors d'enters ordenats $A$ i $B$.

## Sortida

`TRUE` si i només si $B$ és incrustable a $A$.

## Informació del problema

Autoria: Jaume Baixeries

Generació: 2026-01-25T18:28:30.947Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
