// Add or remove includes
#include <iostream>
#include <string>
#include <vector>
#include <cstdlib>
#include <algorithm>
#include <cmath>

using namespace std;

void classify(const vector<double> &v, int &numA, int &numB, int &numC, int &numD);

struct Solution {
    int numA, numB, numC, numD;
    Solution() {
        numA = rand()%1000007;
        numB = rand()%1000007;
        numC = rand()%1000007;
        numD = rand()%1000007;
    }
};

int main()  {
    vector<vector<double> > listinputs;
    vector<Solution> listsolutions;
    vector<int> listattempts;
    int n;
    while (cin >> n) {
        vector<double> v(n);
        for (int i = 0; i < n; i++)
            cin >> v[i];
        listinputs.push_back(v);
        listsolutions.push_back(Solution());
    }
    int repetitions = max(1, 100000/int(listinputs.size()));
    for (int index = 0; index < int(listinputs.size()); index++)
        for (int i = 0; i < repetitions; i++)
            listattempts.push_back(index);
    random_shuffle(listattempts.begin(), listattempts.end());
    for (int r = 0; r < int(listattempts.size()); r++) {
        int i = listattempts[r];
        Solution &s = listsolutions[i];
        classify(listinputs[i], s.numA, s.numB, s.numC, s.numD);
    }
    for (int i = 0; i < int(listsolutions.size()); i++) {
        Solution &s = listsolutions[i];
	    cout << s.numA << " " << s.numB << " " << s.numC << " " << s.numD << endl;
    }
}
