# Aniversaris

Heu d'implementar un programa que manega persones i els anys que tenen.
Hi haurà comandes que afegeixen una persona nova indicant quants anys
té, comandes que demanen escriure el nombre de persones o la llista de
persones amb uns certs anys, i comandes que indiquen que una certa
persona celebra el seu aniversari, de manera que els seus anys
s'incrementen en una unitat.

Més detalladament, hi ha comandes que afegeixen persones noves i la seva
edat (atenció, aquestes comandes d'entrada poden no ser consistents amb
la nostra realitat, doncs pot ser el cas que algú tingui una edat
arbitràriament gran). Per exemple:

    NEWPERSON maria.lapuente 18
    NEWPERSON john.smith 23
    NEWPERSON nuria.margalef 20
    NEWPERSON laura.venture 18
    NEWPERSON joel.cabas 21
    NEWPERSON pau.margallo 17
    NEWPERSON oscar.hoipoi 19

També hi ha comandes que indiquen que algú celebra el seu aniversari,
cas en el qual, el seu nombre d'anys s'incrementa en 1 (atenció,
aquestes comandes d'entrada poden no ser consistents amb la nostra
realitat, doncs pot ser el cas que algú celebri aniversari dos cops
abans que algú altri ho faci una sola vegada):

    BIRTHDAY maria.lapuente
    BIRTHDAY pau.margallo
    BIRTHDAY maria.lapuente
    BIRTHDAY oscar.hoipoi

També hi ha comandes que demanen quantes persones amb una certa edat hi
ha:

    NUMBERWITHAGE 18
    NUMBERWITHAGE 19
    NUMBERWITHAGE 20
    NUMBERWITHAGE 23

Incloent les comandes prèvies, la sortida seria aquesta:

    2
    0
    3
    1

També hi ha comandes que demanen la llista de persones amb una certa
edat, en ordre lexicogràfic:

    PEOPLEWITHAGE 18
    PEOPLEWITHAGE 19
    PEOPLEWITHAGE 20
    PEOPLEWITHAGE 23

Incloent les comandes prèvies, la sortida seria aquesta:

    laura.venture pau.margallo

    maria.lapuente nuria.margalef oscar.hoipoi
    john.smith

**Observació:** Podeu seguir l'enfoc que considereu oportú, i podeu
utilitzar qualsevol de les classes presentades al curs (**string,
vector, stack, queue, list, map, set**) de la manera que considereu
oportuna. Però tingueu en compte que la vostra elecció pot afectar a
l'eficiència de la vostra solució, i per tant al fet de poder superar
tots els jocs de proves o només els públics (cosa que us deixarà amb la
meitat de la nota).

## Entrada

Cada linia de l'entrada consisteix en una instrucció del següent tipus,
a on `person` es pot llegir com string no buit qualsevol, i té menys de
20 caràcters, i `natural` és un natural qualsevol:

- `NEWPERSON person natural`

- `BIRTHDAY person`

- `NUMBERWITHAGE natural`

- `PEOPLEWITHAGE natural`

Se suposa que les dades son correctes en el sentit que `NEWPERSON` no
afegeix persones que ja han estat afegides abans, i que `BIRTHDAY`
s'aplica a persones que ja han estat afegides abans.

## Sortida

Per a cada instrucció `NUMBERWITHAGE natural`, s'escriurà una línia per
la sortida amb el nombre de persones amb l'edat indicada.

Per a cada instrucció `PEOPLEWITHAGE`, s'escriurà una línia per la
sortida amb totes les persones de l'edat indicada, ordenada
lexicogràficament, i separada per espais en blanc.

## Observació

Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost $n\log(n)$ o
inferior, i capaç de superar els jocs de proves públics i privats.
Entenem com a solució lenta una que no és ràpida, però és correcta i
capaç de superar els jocs de proves públics.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T21:28:27.016Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
