# Anniversaries

*To solve this problem you have to complete the code that you will find
at the end of the statement. You have to replace each ??? with one or
more lines of code. **Do not change anything else.** Download from the
website of the problem the file code.cc with the code to be completed
(click on the corresponding button ".CPP"), edit it and submit it to the
judge.*

A historian maintains a database with several anniversaries. For each
one, we have the date, a brief description, and a number that indicates
its relevance. Dates only include the month and the day (in this order),
but not the year. In addition, the system only allows us to save one
event for each date.

The historian's program allows us to do five different operations:

- `n`: It prints the number of stored anniversaries preceded by
  "`number events:`".

- `s` $d$ $e$ $r$: It stores that on date $d$ the event $e$ occurred,
  with relevance $r$. It prints an error message if an event for date
  $d$ has already been saved.

- `a` $d$: We ask the data of the anniversary of date $d$. It is
  guaranteed that an event is stored for that date.

- `m`: It prints the maximum relevance of the events saved so far,
  preceded by "`maximum relevance:`". If there are no anniversaries yet,
  it prints 0.

- `e`: It prints the sum of the relevances of the events of the first
  date and of the last date (in chronological order; a direct string
  comparison works fine). It prints an error message if there are less
  than two events stored.

## Input

Input consists of several operations as indicated above. Dates use two
digits for the month and for the day, and a '`/`' to separate them.
Descriptions are strings made with lowercase letters, digits and dashes.
Relevances are integer numbers between 1 and $10^9$.

## Output

For each operation (except save operations), print the requested
information.

    #include <iostream>
    #include <map>
    using namespace std;


    struct Data {
      string event;
      int relevance;
    };


    int main() {
      int maximum_relevance = 0;
      map<string, Data> M;
      char c;
      while (cin >> c) {
        if (c == 'n') {
          ???
        }
        else if (c == 's') {
          string date, event;
          int relevance;
          cin >> date >> event >> relevance;
          ???
        }
        else if (c == 'a') {
          string date;
          cin >> date;
          ???
        }
        else if (c == 'm') {
          ???
        }
        else { // c == 'e'
          ???
        }
      }
    }

## Problem information

Author: Unknown\
Translator: Salvador Roura

Generation: 2026-01-25T22:33:25.265Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
