# Efemèrides

*Per resoldre aquest problema heu de completar el codi que trobareu al
final de l'enunciat. Hi heu de reemplaçar cada ??? per una o més línies
de codi. **No canvieu res més.** Descarregueu-vos de la web del problema
el fitxer code.cc amb el codi a completar (cliqueu el botó ".CPP"
corresponent), editeu-lo i envieu-lo al jutge.*

Un historiador manté una base de dades amb diverses efemèrides. Per a
cadascuna, en guarda la data, una petita descripció, i un nombre que
n'indica la rellevància. Les dates només inclouen el mes i el dia (en
aquest ordre), però no l'any. A més, el sistema només permet guardar una
efemèride per a cada data.

El programa de l'historiador permet fer cinc operacions diferents:

- `n`: Escriu el nombre d'efemèrides emmagatzemades precedit de
  "`number events:`".

- `s` $d$ $e$ $r$: Guarda que el dia $d$ es va produir l'efemèride $e$,
  la qual té rellevància $r$. Escriu un missatge d'error si ja hi havia
  guardada una efemèride corresponent al dia $d$.

- `a` $d$: Pregunta les dades de l'efemèride de la data $d$. Es
  garanteix que hi ha una efemèride emmagatzemada per a aquesta data.

- `m`: Mostra la màxima rellevància de les efemèrides guardades,
  precedida de "`maximum relevance:`". Si encara no hi ha cap efemèride,
  escriu 0.

- `e`: Escriu la suma de les rellevàncies de les efemèrides de la
  primera data i de l'última data (en ordre cronològic; la comparació
  directa entre strings ja funciona bé). Escriu un missatge d'error si
  hi ha menys de dues dates emmagatzemades.

## Entrada

L'entrada consisteix en diverses operacions segons s'ha indicat
anteriorment. Les dates usen dos dígits per als mesos i els dies, i una
'`/`' per separar-les. Les descripcions són strings amb minúscules,
dígits i guions. Les rellevàncies són enters entre 1 i $10^9$.

## Sortida

Per a cada operació (excepte les de guardar), escriviu la informació
demanada.

    #include <iostream>
    #include <map>
    using namespace std;


    struct Data {
      string event;
      int relevance;
    };


    int main() {
      int maximum_relevance = 0;
      map<string, Data> M;
      char c;
      while (cin >> c) {
        if (c == 'n') {
          ???
        }
        else if (c == 's') {
          string date, event;
          int relevance;
          cin >> date >> event >> relevance;
          ???
        }
        else if (c == 'a') {
          string date;
          cin >> date;
          ???
        }
        else if (c == 'm') {
          ???
        }
        else { // c == 'e'
          ???
        }
      }
    }

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T22:33:30.569Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
