# Simple state machine

Design a sequential network described by the following state/output
table (*PS*: Present State; *NS*: Next state, $z$ is the 2-bit output).
Assume $A$ is the initial state and encode the outputs as $a=00$, $b=01$
and $c=10$.

:::: NoShortVerb
::: center
+------+---------------------+
| *PS* | Input               |
+:====:+:========:+:========:+
|      | $x=0$    | $x=1$    |
+------+----------+----------+
| $A$  | $B,a$    | $F,b$    |
+------+----------+----------+
| $B$  | $C,a$    | $A,c$    |
+------+----------+----------+
| $C$  | $D,a$    | $B,b$    |
+------+----------+----------+
| $D$  | $E,b$    | $C,c$    |
+------+----------+----------+
| $E$  | $F,b$    | $D,b$    |
+------+----------+----------+
| $F$  | $A,c$    | $E,c$    |
+------+----------+----------+
|      | $\textit{NS},z$     |
+------+---------------------+
:::
::::

## Specification

``` verilog
module state_machine(x, z, clk, rst);
    input x, clk, rst;
    output [1:0] z;
```

## Input

- `clk` is the clock signal.

- `rst` is the synchronous reset signal.

- `x` is the input signal.

## Output

- `z` is the 2-bit signal encoding the outputs $a$, $b$ and $c$.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:22:29.785Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
