# Nombres unidígit

Un nombre natural $n$ és pot representar en base $b$ amb una seqüència
de dígits $(d_m, d_{m-1}, \ldots, d_1, d_0)$ tal que
$$n = \sum_{i=0}^{m} d_i\cdot b^i, \qquad \mbox{amb~} 0 \leq d_i < b.$$
Per exemple, 15 es pot representar amb $(1,1,1,1)$ en base 2, 109 es pot
representar amb $(1,2,3,1)$ en base 4 i 10818 es pot representar amb
$(18, 18, 18)$ en base 24, perquè:

$$\begin{eqnarray*}
15 & = & \mathbf{1}\cdot 2^3 + \mathbf{1}\cdot 2^2 + \mathbf{1} \cdot 2^1 + \mathbf{1} \cdot 2^0\\
109 & = & \mathbf{1}\cdot 4^3 + \mathbf{2}\cdot 4^2 + \mathbf{3} \cdot 4^1 + \mathbf{1} \cdot 4^0\\
10818 & = & \mathbf{18} \cdot 24^2 + \mathbf{18} \cdot 24^1 + \mathbf{18} \cdot 24^0
\end{eqnarray*}$$

Diem que un nombre és *unidígit en base $b$* si, quan es representa en
aquella base, tots els dígits de la seqüència són iguals. Als exemples
anteriors, doncs, el 15 és unidígit en base 2 i el 10818 és unidígit en
base 24, però el 109 no és unidígit en base 4.

Es pot observar que tot nombre $n \geq 3$ és unidígit en base $n-1$ amb
la representació $(1,1)$.

## Entrada

L'entrada consisteix en una seqüència de naturals estrictament positius.

## Sortida

Per a cada nombre $x$ de l'entrada cal cercar la base $b$ més petita
($b \geq 2$) per a la qual $x$ és unidígit en base $b$. Una vegada
trobada aquesta base $b$, cal escriure tres informacions: el nombre de
dígits de la representació de $x$ en base $b$, el valor del dígit $d$
que es repeteix en la representació, i la base $b$ trobada.

## Informació del problema

Autoria: Jordi Cortadella

Generació: 2026-01-25T19:41:34.333Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
