# Fracción continua mcd

Este problema sólo se visualiza correctamente en su versión pdf.

Todo número racional $\displaystyle\frac{n}{m}$ se puede representar
como el resultado de una fracción contínua finita.

Por ejemplo:

$$\displaystyle\frac{972}{421} = 
	2 + \displaystyle\frac{1}{3 + \displaystyle\frac{1}{4 + \displaystyle\frac{1}{5 + \displaystyle\frac{1}{6}}}}$$

Esta representación se suele codificar con la lista de los valores
enteros que se suman más el último denominador: \[2, 3, 4, 5, 6\]

Los números de esta lista coinciden con los cocientes del cálculo del
algoritmo de Euclides para el máximo común divisor:

$$\begin{equation}
    mcd(a, b) = mcd(b, a \% b) \\
	
\end{equation}$$ $$\begin{equation}
    mcd(a, 0) = a
	
\end{equation}$$

Las reducidas (P y Q) son las sumas parciales de los quebrados de
enteros de la fracción continua. Cualquier pareja P, Q sirve como
aproximación válida P/Q al racional. Se pueden calcular en paralelo al
mcd:

        ------------------------------
        a |     | 972 421 130  31   6}
        b |     | 421 130  31   6   1}
        r |     | 130  31   6   1   0}-- cálculo del MCD
        q |     |   2   3   4   5   6}
        ------------------------------
        P | 0 1 |   2   7  30 157 972}-- cálculo de las reducidas
        Q | 1 0 |   1   3  13  68 421}
    	

P y Q se han calculado operando de la siguiente manera:

        P -> 1*2+0 2  2*3+1 7  7*4+2 30  30*5+7 157  157*6+30 972
             -----=-, -----=-, -----=--, ------=---, --------=---
        Q -> 0*2+1 1  1*3+0 3  3*4+1 13  13*5+3  68   68*6+13 421
    	

Se pide que diseñes la función $fraccion\_continua\_mcd$ que, dados dos
valores enteros $n$ (numerador) y $m$ (denominador), ambos enteros
positivos, calcule los cocientes y restos del MCD siguiendo el algoritmo
de Euclides y en paralelo calcule las P y Q de las reducidas.

El programa tiene que devolver tres listas: los cocientes del MCD, las P
y las Q.

## Ejemplo de sessión

## Información del problema

Autoría: InfBesos

Generación: 2026-01-25T19:39:19.315Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
