# Practica de PRO2 - Otoño 2019 - entrega final provisional

Este problema corresponde a la entrega final de la práctica, pero no es
necesario entregar la documentación ni el juego de pruebas preparado
para la competencia transversal de Trabajo en Equipo. Por dicha razón es
una entrega final *provisional*. Pero, salvo que se indicase lo
contrario mediante un aviso o aclaración en la web de la asignatura, los
juegos de pruebas públicos y privados sí son los **definitivos**. Tened
en cuenta que:

- Solo es necesario presentar los ficheros fuente (`.hh` y `.cc`) de la
  práctica y el fichero `Makefile`. Pero no está prohibido subir
  ficheros de documentación, juegos de pruebas propios, ...

  En principio, los juegos de pruebas no cambiarán en la entrega final
  definitiva.

- Esta entrega no tendrá nota manual ni automática.

## Entrada

Una secuencia de instrucciones y datos que siguen el formato del
enunciado de la práctica y del juego de pruebas público.

## Salida

Una secuencia de resultados que siguen el formato del enunciado de la
práctica y del juego de pruebas público. N.B.: se ha simplificado el
formato de la salida en las consultas booleanas; en vez de reproducir
una versión "procesada" de la expresión que representa a la consulta
simplemente se imprime `BEGIN_QUERY ... END_QUERY` (es decir, se
imprimen tres puntos suspensivos).

## Observación

El Jutge prueba vuestras entregas mediante 4 juegos de pruebas:

- sample: el juego de pruebas público

- privat1: juego de pruebas que ensaya principalmente las
  funcionalidades de la entrega intermedia (funciones 1--14)

- privat2: juego de pruebas que hace énfasis en las funcionalidades de
  búsqueda por fecha y por etiqueta (funciones 15--16)

- privat3: juego de pruebas que hace énfasis en las funcionalidad de
  consultas booleanas (función 17)

En un fichero llamado `practica.tar` tenéis que entregar

- Los ficheros `.hh` y `.cc` de las clases y el programa principal

- El fichero `Makefile`, que usaremos para generar y probar el
  ejecutable

Tened en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  `program.cc`

- El `Makefile` ha de generar un ejecutable llamado `program.exe`

- Es importante que uséis las opciones de compilación del Jutge de PRO2
  (ved Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 a
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

Producid el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengáis los ficheros que vais a
entregar. Incluid esta instrucción en vuestro Makefile, de forma que el
`.tar` se pueda generar ejecutando `make tar`.

    ---- Fichero Makefile ---------------------------------------

    ...
    clean:
        rm *.o
        ...
    tar: 
        tar -cvf practica.tar Makefile *.cc *.hh
    ...

Con eso reduciréis el riesgo de error en sucesivas entregas. El Jutge no
acepta `.tar` donde los ficheros estén dentro de carpetas. Recomendamos
usar `GNU tar` para reducir el riesgo de que el fichero `practica.tar`
sea incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

## Información del problema

Autoría: PR02

Generación: 2026-01-25T21:27:24.458Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
