# Arbres quasi coincidents amb BinTree

Donats dos BinTree, **a**, **b** d'elements de qualsevol tipus, diem que
són *quasi coincidents* si per a tot node d'**a** existeix un node de
**b** a la mateixa posició i viceversa, tret d'un node com a màxim.

Volem una operació que ens permeti saber si dos BinTree són quasi
coincidents. Feu servir la següent especificació:

    bool quasi_coincidents (const BinTree<int> &a, const BinTree<int> &b)
    /* Pre: cert */
    /* Post: el resultat indica si a i b son quasi coincidents */

Exemple: considereu els quatre arbres següents

    a =    7           b =    4           c =   10           d =   -4      
        /     \            /     \            /     \            /     \   
       6      -2          9       6         -1      -2          6      -2  
      / \     / \        / \     / \        /       / \        / \     /  
    -2  -3  -1   3     -1   3   8  -3     -2      -1   3     -1   3   8   
                                   /
                                  1

- $(a,b)$ són quasi coincidents (només hi ha un node que no correspon,
  l'1); també ho són $(a,c)$ i $(a,d)$

- $(c,d)$ no són quasi coincidents (hi ha dos nodes que no corresponen,
  el 3 de $c$ i el 3 de $d$); tampoc ho són $(b,c)$ i $(b,d)$

## Entrada

L'entrada són dos BinTree.

## Sortida

La sortida és un booleà indicant si els dos BinTree són quasi
coincidents.

## Observació

Només s'ha d'enviar un fitxer que contengui la funció amb la capçalera
de l'enunciat i qualsevol altra funció auxiliar que cregueu convenient,
sense la funció main. Afegiu-hi també l'include de la classe BinTree
mitjançant

#include \"BinTree.hh\"

## Informació del problema

Autoria: pro2

Generació: 2026-01-25T21:27:06.783Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
