# Diferència entre dues cues usant memòria dinàmica

El conjunt diferència entre dos conjunts $A$ i $B$, escrit $A-B$, és el
conjunt d'elements que pertanyen a $A$ però no pertanyen a $B$.

Representem els conjunts $A$ i $B$ amb dues cues d'enters. Escriviu el
codi del mètode `diferencia` de la classe `Cua` que, donada una cua
d'enters, calcula la diferència entre la cua paràmetre implícit (conjunt
$A$) i la cua donada per paràmetre (conjunt $B$), i deixa el resultat en
la cua paràmetre implícit. És a dir, la cua paràmetre implícit passa a
tenir els elements que tenia originalment, excepte els que apareixen a
la cua donada per paràmetre.

Les dues cues estan **ordenades de forma creixent**.

L'especificació d'aquest mètode és:

``` c++
void diferencia(const Cua &q);
/* Pre : La cua p.i. esta ordenada de forma creixent, q esta ordenada de forma
   creixent */
/* Post : La cua p.i. passa a tenir els elements que estaven al p.i original excepte
   els que apareixen a q */
```

## Entrada

L'entrada conté dues cues d'enters. Per cada cua hi ha el seu nombre
d'enters ($n \geq 0$) i els $n$ enters que la formen.

Per llegir les cues, s'ha utilitzat l'operador `>>` que es troba definit
a la classe `Cua`.

## Sortida

Com a sortida es mostren les dues cues d'entrada originals, seguides de
la primera cua modificada amb el resultat de la diferència entre les
dues cues.

Per escriure les cues, s'ha utilitzat l'operador `<<` que es troba
definit a la classe `Cua`.

## Observació

Feu la solució usant els atributs privats de la classe `Cua` en lloc
dels mètodes públics.

Heu d'enviar la solució comprimida en un fitxer .tar:

`tar cvf program.tar cua_diferencia.cpp`

Observeu que per compilar us donem el `Makefile`, la classe `Cua` amb
tots els seus mètodes implementats, excepte `diferencia`, i el programa
principal `program.cpp`.

## Informació del problema

Autoria: Neus Català

Generació: 2026-01-25T21:26:49.010Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
