# Reemplazar plantillas

Escribe una función llamada `reemplazarplantillas`. Dicha función
recibirá como parámetros una cadena de caracteres y un diccionario cuyas
claves y valores son cadenas de caracteres. La función deberá devolver
otra cadena de caracteres.

Muchas veces habrás recibido correos electrónicos que se han generado
automáticamente. Normalmente, un programa de ordenador los crea
basándose en una plantilla y en un diccionario de sustituciones. La
plantilla contiene el texto del correo electrónico que es invariante
para todos los destinatarios y, mediante unas marcas especiales, se le
indica al programa de ordenador dónde debe introducir los datos
particulares del destinatario.

Por ejemplo, en una aplicación de guías de viaje, cuando un usuario se
registra y solicita una guía de viaje para un lugar, se le envía un
mensaje basado en la siguiente plantilla
`Estimado/a ++nombre++, nos gustaría darte la bienvenida a nuestra aplicación. Esperemos que disfrutes la guía de viaje de ++lugar++.`,
donde la marca `++nombre++` se sustituye por el nombre del usuario y la
marca `++lugar++`, por el lugar para el que ha pedido la guía de viaje.

El objetivo de la función `reemplazarplantillas` es generar el mensaje
que recibirá el destinatario en base a una plantilla (primer parámetro)
y un diccionario con los datos que hay que introducir en las marcas
(segundo parámetro).

La cadena de caracteres recibida como primer parámetro será una oración
en castellano. Las marcas a sustituir serán aquellas palabras que
empiecen y acaben por `++`. No será necesario hacer ningún procesamiento
especial con la puntuación, las palabras a sustituir siempre estarán
separadas por espacios del resto de palabras. El diccionario recibido
como segundo parámetro tendrá como claves las marcas, pero sin los
caracteres `++` de principio y final, y como valores, la palabra por la
que hay que sustituir cada marca. Todas las marcas de la oración se
encontrarán en el diccionario. Todas las marcas que aparezcan en la
cadena de caracteres de entrada se corresponderán con claves existentes
en el diccionario. Cualquier signo de puntuación en la entrada que no
forme parte de una marca debe dejarse intacto (incluso los `+`).

Por ejemplo, para la cadena de entrada,
`Estimado/a ++nombre++ , nos gustaría darte la bienvenida a nuestra aplicación . +++++++++++ Esperemos que disfrutes la guía de viaje de ++lugar++`,
y el diccionario {@\"nombre\": \"Paco\" , \"lugar\": \"Nueva York\"@},
la función deberá devolver la cadena
`Estimado/a Paco , nos gustaría darte la bienvenida a nuestra aplicación . +++++++++++ Esperemos que disfrutes la guía de viaje de Nueva York`.

Para que tu función pueda ser evaluada correctamente por el juez en
línea, tu código deberá tener la siguiente forma:

``` python
import sys

def reemplazarplantillas(oracion,d):
...

o=sys.stdin.readline().strip()
d=eval(sys.stdin.readline().strip())
resultado=reemplazarplantillas(o,d)
print(resultado)
```

## Entrada

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) Dos líneas. La primera contendrá la plantilla, y
la segunda, el diccionario de reemplazos, como si se tratara de código
fuente Python.

## Salida

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) El resultado de reemplazar los elementos de la
plantilla.

## Información del problema

Autoría: Víctor M. Sánchez Cartagena

Generación: 2026-01-25T19:37:10.910Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
