# Vending machine

We have to design the control of a vending machine that dispenses a bag
of cookies for 3€. The machine only accepts 1€ and 2€ coins. The machine
has a coin slot that detects the insertion of a coin and distinguishes
between 1€ and 2€ coins. Each time a coin is inserted, a 1-cycle pulse
is generated on signal `E1` or `E2`, depending on the type of coin.
Since the machine only has one coin slot, no two coins can be inserted
simultaneously.

After the insertion of 3€, the machine must dispense a bag of cookies by
activating a signal called `Cookies` for one cycle. Additionally, if the
customer has inserted 4€, the machine will dispense a 1€ change by
activating the signal `Change` on the same cycle the cookies are
dispensed.

The machine will not accept more coins while the cookies and the change
are dispensed.

The following figure illustrates a possible waveform of the vending
machine control.

::: center
![image](waveform.png){width="12cm"}
:::

## Specification

``` verilog
module Vending_Machine(E1, E2, Cookies, Change, clk, rst);
    input E1, E2, clk, rst;
    output Cookies, Change;
```

## Hint

The state machine can be implemented with 5 states.

## Input

- `E1` is the input indicating the insertion of a 1€ coin.

- `E2` is the input indicating the insertion of a 2€ coin.

- `clk` is the clock signal.

- `rst` is the synchronous reset signal.

## Output

- `Cookies` is the output that activates the delivery of cookies.

- `Change` is the output that activates the return of change.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:24:47.318Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
