from pytokr import item

from heapq import *
#
# Utilizamos el módulo heapq, que son heaps implementados por Python. Tenemos las
# funciones 'heapify(lst)', 'heappush(heap, element)' (nuestro 'inserir')
# i 'heappop(heap)' (nuestro 'obtenir' o 'obtenir_min')
#

#------------------------------------------------------------------

# Lectura grafo DIRIGIDO con listas de adyacéncia, y los nodos
# son números enteros 0...N-1 (si el grafo tiene N nodos)

def leer_grafo_etiquetado():
    n = int(item())   # número de vertices |V|
    m = int(item())   # número de aristas |E|
    G = [[] for _ in range(n)]
    for i in range(m):     # m pares u,v,w: arista u --w--> v
        u = int(item())
        v = int(item())
        w = int(item())
        G[u].append((w,v))
    return G

#------------------------------------------------------------------

def dijkstra(G, s, e, excluded=None):
    # Entrada: Grafo G=(V,E), en formato de llegir_graf_etiquetat; vértice inicial s,
    #          vértice final e y una lista de tuplas (u,v) de aristas que hay que excluir
    #          de los caminos considerados.
    # Salida:  dist -- distancia de s a e, camí -- camino mínimo de s a e
    #                                              

    N = len(G)                  # Número de vértices
    prev = [None]*N
    dist = [float('inf')]*N
    dist[s] = 0

    minheap = [(0,s)]
    heapify(minheap)
    
    while len(minheap) > 0:
        d,u = heappop(minheap)
        if d == dist[u]:
            for w,v in G[u]:
                if (not excluded or (excluded and (u,v) not in excluded)) and dist[v] > dist[u] + w:
                    dist[v] = dist[u] + w 
                    prev[v] = u 
                    heappush(minheap,(dist[v],v))

    # Ahora que tenemos prev, es necesario reconstruir el camino mínimo para 'e'.
    # Cálculo camino para el vértice 'e'
    cami   = [e]
    vertex = e
    while vertex != s and vertex != None:
        vertex = prev[vertex]
        cami = [vertex] + cami 
    
    return dist[e], cami if vertex is not None else None # la distancia será float('inf') si no hay camino

#------------------------------------------------------------------

def segundo_mejor_camino(G, s, e):
    """
    G es un grafo dirigido y etiquetado con números en las aristas
    s es el vértice de partida (un número entre 0 y N-1, donde N es el número de vértices de G)
    e es el vértice de llegada (un número entre 0 y N-1, donde N es el número de vértices de G)
    RETORNA: El coste del camino de coste mínimo de s a e, que no contiene NINGUNA arista de las que componen
             el camino de coste mínimo de s a e calculado sin restricción alguna (-1 si no existe)
    """
    # Aquí debe escribir el código de su solución al problema

#----------------------------------------------------------------------------

G = leer_grafo_etiquetado()
s = int(item())
e = int(item())
print(segundo_mejor_camino(G,s,e))

