from pytokr import item

from heapq import *
#
# Fem servir el mòdul heapq, que són heaps implementats per Python. Tenim les
# funcions 'heapify(lst)', 'heappush(heap, element)' (el nostre 'inserir')
# i 'heappop(heap)' (el nostre 'obtenir' o 'obtenir_min')
#

#------------------------------------------------------------------

# Lectura graf DIRIGIT amb llistes d'adjacència, i els nodes
# són nombres enters 0...N-1 (si el graf té N nodes)

def llegir_graf_etiquetat():
    n = int(item())   # nombre de vertexos |V|
    m = int(item())   # nombre d'arestes |E|
    G = [[] for _ in range(n)]
    for i in range(m):     # m parelles u,v,w: aresta u --w--> v
        u = int(item())
        v = int(item())
        w = int(item())
        G[u].append((w,v))
    return G

#------------------------------------------------------------------

def dijkstra(G, s, e, excluded=None):
    # Entrada: Graf G=(V,E), en format de llegir_graf_etiquetat; vèrtex inicial s,
    #          vèrtex final e i una llista de tuples (u,v) d'arestes que cal excloure
    #          dels camins considerats.
    # Sortida: dist -- distància de s a e, camí -- camí mínim de s a e
    #                                              

    N = len(G)                  # Nombre de vertexos
    prev = [None]*N
    dist = [float('inf')]*N
    dist[s] = 0

    minheap = [(0,s)]
    heapify(minheap)
    
    while len(minheap) > 0:
        d,u = heappop(minheap)
        if d == dist[u]:
            for w,v in G[u]:
                if (not excluded or (excluded and (u,v) not in excluded)) and dist[v] > dist[u] + w:
                    dist[v] = dist[u] + w 
                    prev[v] = u 
                    heappush(minheap,(dist[v],v))

    # Ara que tenim prev, cal reconstruir el camí mínim per a 'e'
    # calculo camí per al vèrtex 'e'
    cami   = [e]
    vertex = e
    while vertex != s and vertex != None:
        vertex = prev[vertex]
        cami = [vertex] + cami 
    
    return dist[e], cami if vertex is not None else None # la distància serà float('inf') si no hi ha camí

#------------------------------------------------------------------

def segon_millor_cami(G, s, e):
    """
    G és un graf dirigit i etiquetat amb nombres a les arestes
    s és el vertex de partida (un nombre entre 0 i N-1, on N és el nombre de vertexos de G)
    e és el vertex d'arribada (un nombre entre 0 i N-1, on N és el nombre de vertexos de G)
    RETORNA: El cost del camí de cost mínim d's a e, que no conté CAP aresta de les que composen
             el camí de cost mínim d's a e calculat sense cap restricció (-1 si no existeix)
    """
    # Aquí heu d'escriure el codi de la vostra solució al problema

#----------------------------------------------------------------------------

G = llegir_graf_etiquetat()
s = int(item())
e = int(item())
print(segon_millor_cami(G,s,e))

