# Práctica de PRO2 - Otoño 2021 - Entrega final definitiva

Este problema es el único canal disponible para realizar **la entrega
definitiva** de la práctica y también **la entrega de los materiales
para evaluar la competencia transversal "Treball en equip"**. Tened en
cuenta que

- El plazo de entrega acaba el martes 30 de noviembre, a las 22h.

- Esta es la entrega que dará lugar a la mayor parte de la nota de la
  práctica (90%); la nota de la entrega tendrá una parte procedente de
  corrección automática y otra procedente de corrección manual
  (consultad los detalles en el pdf sobre evaluación en el apartado
  "Pràctica" de la web de PRO2)

- No superar ningún juego de pruebas conllevará un cero en la nota de la
  entrega

- En esta entrega pedimos más cosas, que detallamos a continuación **en
  negrita**, además del código de la práctica y el Makefile, de las que
  se pedían en la entrega provisional

- Pueden realizarse tantas entregas como se quiera, pero solo se tendrá
  en cuenta la más reciente

- El problema de la entrega final provisional seguirá disponible hasta
  el día anterior al fin del plazo de entrega. De hecho, recomendamos
  usarlo para probar el código mientras no tengáis preparado el material
  adicional que pedimos

## Observación

El Jutge prueba vuestras entregas mediante 4 juegos de pruebas:

- sample: el juego de pruebas público

- privat1: combinación de los juegos de pruebas de la entrega intermedia
  con un caso nuevo (nueva rejilla grande no válida)

- privat2: un poco de todo, salvo eficiencia

- privat3: eficiencia de los algoritmos de patrones

En un fichero llamado `practica.tar` tenéis que entregar

- Los ficheros .hh y .cc de las clases y el programa principal **con los
  comentarios Doxygen correspondientes**. No incluyáis ficheros .o y
  similares.

- El fichero Makefile, que usaremos para generar y probar el ejecutable

- **Un fichero `html.zip`, obtenido comprimiendo la carpeta html del
  Doxygen generado a partir de los .hh y .cc anteriores. Dicha
  documentación no solo ha de incluir la parte pública de las clases
  (como en la entrega de la especificación) sino también la parte
  privada (atributos y métodos privados) y la implementación de todas
  las operaciones**

- **Un único integrante de cada equipo ha de entregar un fichero .zip
  con los materiales requeridos para evaluar la competencia "Treball en
  equip", siguiendo las instrucciones contenidas en el documento
  correspondiente, disponible en el apartado "Pràctica" de la página web
  de la asignatura**

Tened en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  `program.cc`

- El Makefile ha de generar un ejecutable llamado `program.exe`

- Es importante que uséis las opciones de compilación del Jutge de PRO2
  (ved Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 a
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

- **Si no se entrega la documentación generada por el Doxygen, o ésta es
  incompleta (por ejemplo, si no se pueden ver los elementos privados o
  la implementación de todas las operaciones), la nota de la corrección
  manual será cero. Comprobad que vuestra documentación es correcta
  antes de la entrega. Es necesario usar un `Doxyfile` basado en el de
  la sesión 10 de laboratorio para generar correctamente la
  documentación**

Producid el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengáis los ficheros que vais a
entregar. Incluid esta instrucción en vuestro Makefile, de forma que el
`.tar` se pueda generar ejecutando `make practica.tar`. Con eso
reduciréis el riesgo de error en sucesivas entregas. El Jutge no acepta
`.tar` donde los ficheros estén dentro de carpetas. Recomendamos usar
`GNU tar` para reducir el riesgo de que el fichero `practica.tar` sea
incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

## Información del problema

Autoría: PRO2

Generación: 2026-01-25T21:26:03.423Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
