# Ocurrències caràcters minúscula-fila i majúscula-columna

Ens donen una matriu $M$ de mida $n\times{}m$ de lletres majúscules o
minúscules, és a dir, $n$ strings amb $m$ caràcters pertanyents als
codis ASCII `[’a’,…,’z’]`$\cup$`[’A’,…,’Z’]`. Per a cada posició $(i,j)$
de $M$ hi trobem un cert caràcter. Volem sumar el nombre de vegades que
apareix aquest caràcter en minúscula a la fila $i$, més el nombre de
vegades que apareix aquest caràcter en majúscula a la columna $j$.

Per exemple, considereu la següent matriu de caràcters:

    BceaDc
    BBFbaa
    FafbfE
    AABbff

Indexant des de $0$, a la posició $(2,2)$ hi ha una `f`. A la fila $2$
hi tenim els caràcters `F,a,f,b,f,E` i per tant hi han $2$ ocurrències
de `f` (minúscula). A la columna $2$ hi tenim els caràcters `e,F,f,B`, i
per tant hi ha $1$ ocurrència de `F` (majúscula). En total, $2+1=3$
ocurrències.

Veiem un altre exemple amb la matriu anterior: a la posició $(1,3)$ hi
ha una `b`. A la fila $1$ hi tenim els caràcters `B,B,F,b,a,a` i per
tant hi ha $1$ ocurrència de `b` (minúscula). A la columna $3$ hi tenim
els caràcters `a,b,b,b`, i per tant hi han $0$ ocurrències de `B`
(majúscula). En total, $1+0=1$ ocurrència.

## Entrada

La primera línia de l'entrada té dos valors positius $n,m$ separats per
un espai que representen les mides de la matriu $M$. A continuació venen
$n$ línies amb strings de longitud $m$, a on cada string conté caràcters
amb codis ASCII de `[’a’,…,’z’]`$\cup$`[’A’,…,’Z’]`, el contingut de la
matriu $M$.

## Sortida

La sortida té $n$ línies. Cada línia té $m$ valors naturals separats per
espais. La sortida representa una matriu $n\times{}m$ de naturals. El
valor de la posició $(i,j)$ és la suma del nombre d'ocurrències del
caràcter $M[i][j]$ en minúscula a la fila $i$ de $M$, més el nombre
d'ocurrències del caràcter $M[i][j]$ en majúscula a la columna $j$ de
$M$.

## Observació

Per a superar uns quants jocs de proves i obtenir una nota acceptable
podeu fer un programa senzill. Però per a superar tots els jocs de
proves convindrà pensar en alguna optimització raonable.

## Informació del problema

Autoria: FOPR

Generació: 2026-01-25T19:33:02.296Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
