# Rectangle Inclusion

Write a function \@inclusion(x1, y1, x2, y2)@ that receives the
dimensions of two rectangles $(x1,y1)$ and $(x2,y2)$ (all four numbers
are strictly positive integers) and checks whether the first fits inside
the second, the other way round, or none of both options. The funcion
must return "`first inside second`", "`second inside first`", or
"`none`" respectively. If two rectangles have the same size, are
considered as "`first inside second`".

Note that the rectangles may be rotated 90$^{\circ}$ if that makes the
fitting possible

For example, the call `inclusion(6,3,4,2)` corresponds to the rectangles
with sizes $6\times{3}$ and $4\times{2}$:

     +----+   +--+
     |    |   +--+
     +----+

and the expected answer is "`second inside first`".

The call `inclusion(3,6,4,2)` corresponds to the rectangles with sizes
$3\times{6}$ and $4\times{2}$:

     +-+
     | |
     | |   +--+
     | |   +--+
     | |
     +-+

and the expected answer is also "`second inside first`", since it would
fit if we turned 90$^{\circ}$ any of them.

The call `inclusion(6,3,7,2)` corresponds to the rectangles with sizes
$6\times{3}$ and $7\times{2}$:

     +----+   +-----+
     |    |   +-----+
     +----+

and the expected answer is "`none`", since no rectangle fits in the
other, with or without 90$^{\circ}$ turn.

Finally, the call `inclusion(4,2,3,6)` corresponds to the rectangles
with sizes $4\times{2}$ and $3\times{6}$:

             +-+
             | |
      +--+   | | 
      +--+   | |  
             | |
             +-+

and the expected answer is "`first inside second`", since it would fit
after a 90$^{\circ}$ turn.

## Sample session

## Problem information

Author: ProAl

Generation: 2026-01-25T19:32:23.852Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
