# Robot with light sensors

We are designing a robot that must move towards a light source. The
robot has three photosensors mounted at the front of the robot. The
three sensors are separated by angles of $45^o$ pointing at the left,
center and right, respectively. Each sensor has a digital output that is
1 when the sensor receives light and 0 otherwise.

The robot also has two wheels at the right and the left. When the right
wheel is powered, the robot turns to the left. Similarly, when the left
wheel is powered, the robot turns to the right. If both wheels are
powered, the robot is propelled forward.

Since the sensors are separated by $45^o$-angles, the left and right
sensors can never receive light simultaneously. If the left sensor (LS)
detects light, the robot should turn to the left. Similarly, if the
right sensor (RS) detects light, the robot should turn to the right.
When only the central sensor (CS) receives light, the robot should move
forward. When no sensor detects light, the robot should turn to the left
trying to find light on the back of the robot (Another option could have
been to turn right. However, we arbitrarily chose to turn left to avoid
any ambiguity in the specification of the problem.).

Design a circuit that reads the inputs from the sensors and produces the
outputs that activate the right wheel (RW) and the left wheel (LW).

## Specification

``` verilog
module robot(RS, CS, LS, RW, LW);
   input RS, CS, LS;
   output RW, LW;
```

## Input

- `LS`, `CS` and `RS` are the inputs coming from the left, center and
  right photosensor, respectively.

## Output

- `RW` and `LW` are the outputs that activate the right and left wheels,
  respectively.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:16:03.511Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
