# Accumulator

Design a circuit that accumulates the values received at the input. The
circuit receives an 8-bit input and generates an 8-bit output that
represents the sum of all the inputs received at the previous cycles.
After `rst` is asserted, the output must be zero. The following waveform
illustrates the operation of the circuit.\

::: center
![image](waveform.png){width="12cm"}
:::

## Specification

``` verilog
module accumulator(in, out, clk, rst);
    input [7:0] in;
    input clk, rst;
    output [7:0] out;
```

## Input

- `in` represents the 8-bit input number.

- `clk` is the clock signal.

- `rst` is the reset signal.

## Output

- `out` represents the 8-bit output.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:10:50.728Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
