# The random walker

A *random walker* is an agent that randomly decides which direction to
go at each step.

We want a function $walker(x, y, steps)$ that given the original
coordinates $(x,y)$ of the random walker, and a string with the
direction to take at each step, computes the final coordinates of the
walker.

The string $steps$ contains only the characters '`N`', '`S`', '`E`', and
'`W`'. North ('`N`') means moving up one position in the $y$ axis, and
South ('`S`') moving down one position in $y$. Similarly, East ('`E`')
and West ('`W`') correspond to moving along the $x$ axis one position
right or left, respectively.

For instance if the walker starts at position `A` $(4,1)$ in the picture
below, and the string with the steps taken is 'NEENWNWWS', the walker
will follow the path through positions marked with stars in the picture,
and the final position will be `B` $(3,3)$.

       |
     4-|        *--*--*  
       |        |     |
     3-|        B     *--*
       |                 |
     2-|           *--*--*
       |           |
     1-|           A
       | 
     0 +--|--|--|--|--|--|--
       0  1  2  3  4  5  6  

**Important:** Only the function is expected. If you submission includes
a main program, it has to be either commented out, or under the
condition     `if __name__ == "__main__":`

## Problem information

Author: ProAl1 professors

Generation: 2026-01-25T19:29:28.800Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
