# Eliminar nodes amb un fill d'un arbre binari usant memòria dinàmica

Escriviu el codi del mètode `elimina_nodes_amb_un_fill` de la classe
`arbreBin` que, donat un arbre binari d'enters, elimina els nodes que
només tenen un fill.

``` c++
void elimina_nodes_amb_un_fill();
/* Pre: true */
/* Post: S'han eliminat els nodes del p.i. que tenen un fill */
```

## Entrada

Com a entrada hi haurà la mida de l'arbre i els nodes de l'arbre binari
en postordre. Per cada node s'indica el seu valor i el nombre de fills
(2 fills, -1 indica un fill esquerra, 1 indica un fill dret o 0 fills).

Per llegir els arbres, s'ha utilitzat l'operador `>>` que es troba
definit a la classe `arbreBin`.

## Sortida

Com a sortida es mostrarà l'estructura de l'arbre binari abans i desprès
d'haver eliminat els nodes que només tenen un fill.

Per escriure els arbres, s'ha utilitzat l'operador `<<` que es troba
definit a la classe `arbreBin`.

## Observació

Feu la solució usant els atributs privats de la classe enlloc dels
mètodes públics. Per això s'ha definit a la part privada de la classe
aquest mètode que també heu d'implementar:

``` c++
static node_arbre* elimina_nodes_amb_un_fill(node_arbre* p);
/* Pre: true */
/* Post: S'han eliminat els nodes de l'arbre apuntat per p que
   tenen un fill. Retorna el punter on s'inicia l'arbre modificat */
```

Heu d'enviar la solució comprimida en un fitxer .tar:

`tar cvf program.tar arbreBin_elimina_nodes_amb_un_fill.cpp`

Observeu que per compilar us donem el `Makefile`, la classe `arbreBin`
amb tots els seus mètodes implementats excepte els dos mètodes
`elimina_nodes_amb_un_fill` i el programa principal `program.cpp`.

## Informació del problema

Autoria: Neus Català - Jordi Esteve

Generació: 2026-01-25T21:24:35.863Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
