# Intercalar dues cues

Implementeu una funció **ITERATIVA** que, donades dues cues com a
paràmetre, retorna una cua que s'obté intercalant els valors de les dues
cues rebudes. Més concretament, siguin $[a_1,a_2,\ldots,a_n]$ i
$[b_1,b_2,\ldots,b_m]$ els elements de les dues cues escrits des del
front fins al final. La cua resultant es calcula així:

- En el cas en que $n\geq m$, la cua resultant serà
  $[a_1,b_1,a_2,b_2,\ldots,a_m,b_m,a_{m+1},a_{m+2},\ldots,a_n]$.

- En el cas en que $n<m$, la cua resultant serà
  $[b_1,a_1,b_2,a_2,\ldots,b_n,a_n,b_{n+1},b_{n+2},\ldots,b_m]$.

<!-- -->

    // Pre:  Siguin [a1,a2,...,an] i [b1,b2,...,bm] els valors inicials de q1 i q2, respectivament.
    // Post: En el cas n>=m, la cua retornada és [a1,b1,a2,b2,...,am,bm,a{m+1},a{m+2},...,an].
    //       En el cas n<m, la cua retornada és [b1,a1,b2,a2,...,bn,an,b{n+1},b{n+2},...,bm].
    queue<int> intercal(queue<int> q1, queue<int> q2);

Aquí tenim un exemple de comportament de la funció:

    intercal([1 3 2 5],[2 7 6 1 3 9]) = [2 1 7 3 6 2 1 5 3 9]

## Observació

Només cal enviar el procediment demanat; el programa principal serà
ignorat.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
cues. Heu de trobar una solució **ITERATIVA** i eficient del problema.

Avaluació sobre 10 punts:

- Solució lenta: 7 punts.

- solució ràpida: 10 punts.

Entenem com a solució lenta una que és correcta i capaç de superar els
jocs de proves públics. Entenem com a solució ràpida una que és correcta
i capaç de superar els jocs de proves públics i privats.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T19:23:59.731Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
