# Programming teams balanced in solidarity

A multinational corporation participates in the CodeStrengths
programming competitions with several teams of programmers every year.
When organizing the teams, they always build a first team out of the
best programmers from the company, next a second team out of the
remaining best programmers from the company, and so on.

This year, in order to make a gesture in support of solidarity and peace
amongst all the peoples of the world, the company has decided to form
teams with only programmers from their staff who are from Russia and the
US, so that, if possible, the teams are made out of programmers from
both groups and in a balanced way.

However, the first criterion used to form a team keeps being the
programming level. For example, the first team shouldn't have a
programmer whose level is worse than another one who is not in the first
team.

As second criterion, they will try to make each team as balanced as
possible. For example, if the teams are formed by four people, then a
team with two Russians and two Americans is wanted more than one with
three Russians and just one American, and the latter is wanted more than
a team with four Russians and no American.

As a last criterion, programmers are chosen in lexicographic order
(standard comparison order between strings).

## Input

The input has several cases. The first line of each case has a positive
natural $k$, which is the number of members of each team to form. On a
second line there is a positive natural $n_1$, which is the total number
of Russian programmers. Next, $n_1$ lines follow, each with the name of
a Russian programmer and a positive natural indicating his/her
programming level. These lines are sorted from bigger to smaller
programming level, and in lexicographic order for programmers with the
same level. Next, there is a new line with a positive natural $n_2$,
which is the number of American programmers. Next, $n_2$ lines follow,
with the information about American programmers, following exactly the
same format as for Russian programmers.

It is guaranteed that $n_1+n_2$ is a multiple of $k$, and that there is
no repetition of names. In particular, a name from one of the lists does
not occur in the other list.

## Output

For each case, $(n_1+n_2)/k$ lines must be written. First line will
contain the list of names of first team in lexicographic order. Second
line will contain the list of names of second team in lexicographic
order. And so on. After the output for each case, there is a blank line.

## Observation

Grading up to 10 points:

- Slow solution: 5 points.

- Fast solution: 10 points.

We understand as a fast solution one which is correct, with linear cost
($(n_1+n_2)\log(k)$ is allowed in order to sort the members of each
resulting team) and which passes the public and private tests. We
understand as slow solution one which is not fast, but it is correct and
passes the public tests.

## Problem information

Author: PRO1

Generation: 2026-01-25T22:08:43.086Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
