import sys

#--------------------------------------------------------------------------------

class Llista:

    # ----------------------------------------------------
    # Classe interna per definir els elements de la llista:
    # Cada element de la llista serà una instància de _Node
    class _Node:
        __slots__ = '_element','_next','_prev' # opcional, per eficiència
        
        def __init__(self, prev, next, element=None): 
            self._element = element            # ref. a l'element emmagatzemat
            self._next = next                  # referència al proper node
            self._prev = prev                  # referència al node anterior 
    # ----------------------------------------------------
            
    def __init__(self):
        self._sentinella = self._Node(None,None)   # _Node sentinella
        self._sentinella._next = self._sentinella
        self._sentinella._prev = self._sentinella
        self._cursor   = self._sentinella
        self._n        = 0                    # nombre d'elements (sense sentinella!)

    def mida(self):                         
        return self._n

    def buida(self):
        return self._n == 0

    # Comprova si el cursor és al principi
    # de la llista 
    def principi(self):
        return self._cursor == self._sentinella._next
  
    # Comprova si el cursor és al final
    # de la llista    
    def final(self):
        return self._cursor == self._sentinella

    # Mou el cursor una posició enrere
    def enrere(self):
        # Pre: el cursor NO està al començament
        assert not self.principi() 
        self._cursor = self._cursor._prev

    # Mou el cursor una posició endavant   
    def endavant(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        self._cursor = self._cursor._next

    # Mou el cursor al principi de la llista
    def anar_al_principi(self):
        self._cursor = self._sentinella._next

    # Mou el cursor al final de la llista 
    def anar_al_final(self):
        self._cursor = self._sentinella # !!!

    # Retorna l'element referenciat pel cursor
    def element(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        return self._cursor._element

    # Insereix l'element x abans del cursor
    def inserir(self, x):
        p = self._Node(self._cursor._prev, self._cursor, x)
        self._cursor._prev._next = p
        self._cursor._prev = p
        self._n += 1
        return self

    # Elimina l'element ref. pel cursor
    # i avança el cursor una posició
    def eliminar(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        p = self._cursor
        p._next._prev = p._prev
        p._prev._next = p._next
        self._cursor = p._next
        self._n -= 1

    # Mètode que, DESTRUCTIVAMENT, inverteix la llista
    def invertir(self):
        if not self.buida():
            to_change = self._sentinella
            # simulo un do...while
            next_to_change = to_change._next
            to_change._prev, to_change._next = to_change._next, to_change._prev
            to_change = next_to_change
            while not to_change == self._sentinella:
                next_to_change = to_change._next
                to_change._prev, to_change._next = to_change._next, to_change._prev
                to_change = next_to_change

    def __str__(self):
        if not self.buida():
            p = self._sentinella._next
            s = str(p._element)
            p = p._next
            while p != self._sentinella:
                s += ' -- ' + str(p._element)
                p = p._next
            return s
        return ''

    def transformar(self, f):
        l = Llista()
        p = self._sentinella._next
        while (p != self._sentinella):   # Visitar tots els elements i aplicar f a cada un d'ells
            l.inserir(f(p._element))     
            p = p._next
        return l

    def filtrar(self, f):
        l = Llista()
        p = self._sentinella._next
        while (p != self._sentinella): # tria elements només si f és True
           if f(p._element):
               l.inserir(p._element)
           p = p._next
        return l

    def reduce(self, x0, f):
        x = x0
        p = self._sentinella._next
        while (p != self._sentinella):
            x = f(x, p._element)       
            p = p._next
        return x

    def __iter__(self):
        self.anar_al_principi()
        return self

    def __next__(self):
        if self.final():
            raise StopIteration
        else:
            resultat = self.element()
            self.endavant()
            return resultat      

#--------------------------------------------------------------------------------

def suma_igual(l1,l2):
    """
    PRE: l1 i l2 són instàncies de la classe Llista, no buides i amb nombres enters com a elements
       A la llista de suma menor se li afegiran tants uns com calgui fins a igualar la suma.
    RETORNA: None (és a dir, no retorna res ja que modifica una de les llistes)
    """
    # ... Aquí heu de posar el cos de la funció que us demana l'enunciat ... <=====================

#--------------------------------------------------------------------------------

line1 = sys.stdin.readline()
line1 = list(map(int,line1.split()))
line2 = sys.stdin.readline()
line2 = list(map(int,line2.split()))

l1 = Llista()
for e in line1:
    l1.inserir(e)
l2 = Llista()
for e in line2:
    l2.inserir(e)

suma_igual(l1,l2)

print(l1)
print(l2)

