# Triangle de Pascal

El triangle de Pascal serveix per a calcular coeficients binomials (per
exemple, fins a $n=4$):

  -------- ---------------- ---------------- ---------------- ---------------- ---------------- -- -- -- --
    $n=0$:  $\binom{0}{0}$                                                                               
    $n=1$:  $\binom{1}{0}$   $\binom{1}{1}$                                                              
    $n=2$:  $\binom{2}{0}$   $\binom{2}{1}$   $\binom{2}{2}$                                             
    $n=3$:  $\binom{3}{0}$   $\binom{3}{1}$   $\binom{3}{2}$   $\binom{3}{3}$                            
    $n=4$:  $\binom{4}{0}$   $\binom{4}{1}$   $\binom{4}{2}$   $\binom{4}{3}$   $\binom{4}{4}$           
                                                                                                         
  -------- ---------------- ---------------- ---------------- ---------------- ---------------- -- -- -- --

Els valors d'aquest Triangle de Pascal (per a $n=4$) són:

  -------- ---------------- ---------------- ---------------- ---------------- ---------------- -- -- -- --
    $n=0$:        1                                                                                      
    $n=1$:        1                1                                                                     
    $n=2$:        1                2                1                                                    
    $n=3$:        1                3                3                1                                   
    $n=4$:        1                4                6                4                1                  
              $\uparrow$       $\uparrow$       $\uparrow$       $\uparrow$       $\uparrow$             
            $\binom{4}{0}$   $\binom{4}{1}$   $\binom{4}{2}$   $\binom{4}{3}$   $\binom{4}{4}$           
                                                                                                         
  -------- ---------------- ---------------- ---------------- ---------------- ---------------- -- -- -- --

Es tracta de calcular els coeficients binomials fins a un $n$
determinat. Cal tenir en compte les següents relacions per a calcular el
triangle de Pascal:

$$\binom{n}{0} = \binom{n}{n} = 1$$

$$\binom{n}{k-1} + \binom{n}{k} = \binom{n+1}{k}$$

Amb aquestes dues relacions, en teniu prou per a calcular el triangle de
Pascal fins a nivell $n$. El que heu de fer és un programa tal que
llegeixi un $n$ del teclat, i escrigui per pantalla el triangle de
nivell $n$.

Per exemple, si $n = 4$ cal que el programa escrigui per pantalla:

::: center
  --- --- --- --- --- -- -- -- --
   1                           
   1   1                       
   1   2   1                   
   1   3   3   1               
   1   4   6   4   1           
                               
  --- --- --- --- --- -- -- -- --
:::

**Pista**: Penseu que per a calcular els resultats de la fila $n = i$
només cal que tingueu calculats els resultats de la fila $n = i-1$. Això
vol dir que caldrà desar els resultats de la fila $n = i$ per quan
volgueu calcular els resultats de la fila $n = i + 1$.

Tingueu en compte que **no se us demana una funció, sinó un programa**.

## Entrada

Un enter $N$ tal que $2 \leq N$.

## Sortida

El triangle de Pascal de $N$ files.

## Informació del problema

Autoria: Jaume Baixeries

Generació: 2026-01-25T18:27:14.305Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
