# Avaluar expressions amb variables

**PRELIMINARS:**

En aquest exercici assumim que ja heu resolt un exercici anterior a on
havieu d'avaluar expressions sense variables. Haureu d'adaptar la
solució d'aquell exercici al cas en que la expressió a avaluar té
variables. Els valors de les variables es passaran com a paràmetre en un
`map<string,int>`.

**INTRODUCCIÓ:**

Considerarem arbres que representen expressions sobre els operadors
`+,-,*`, i sobre operands naturals i variables enteres (una variable
serà una seqüència de lletres minúscules). Per exemple, l'arbre
`-(+(3,*(4,x)),y)` representa l'expressió `3+4*x-y`.

Per a guardar els valors assignats sobre les variables usarem un map
d'identificadors de variables a enters declarat així en el nostre
programa C++:

    #include <map>
    ...
    map<string,int> variable2value;

Aquest tipus de dades es pot utilitzar així en C++:

    // Guarda 3 com a valor associat a l'string "hola":
    variable2value["hola"] = 3;
    // Suma 2 al valor associat a l'string "hola":
    variable2value["hola"] = variable2value["hola"] + 2;
    // Escriu el valor associat a l'string "hola" sobre la sortida estandard
    // (en aquest cas escriuria 5):
    cout << variable2value["hola"];

**EXERCICI:**

Implementeu una funció que, donats els valors actuals de les variables,
i donat un arbre binari d'strings que representa una expressió correcta
sobre naturals i variables enteres, i operadors `+,-,*`, retorna la seva
avaluació. Aquesta és la capcelera:

    // Pre:  t és un arbre no buit que representa una expressió correcta
    //       sobre naturals i variables enteres, i els operadors +,-,*.
    //       Totes les variables que apareixen a t estan definides a variable2value.
    //       Les operacions no produeixen errors d'overflow.
    // Post: Retorna l'avaluació de l'expressió representada per t.
    int evaluate(map<string,int> &variable2value, const BinaryTree<string> &t);

Aquí tenim un exemple de paràmetre d'entrada de la funció i la
corresponent sortida:

    evaluate({x:2, y:3}, *(+(1,x),-(5,y))) = 6

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`Makefile, program.cpp, BinaryTree.hpp, evaluate.hpp, utils.hpp, utils.cpp`.
Us falta crear el fitxer `evaluate.cpp` amb els corresponents `includes`
i implementar-hi la funció anterior. Valdrà la pena que utilitzeu
algunes de les funcions oferides a `utils.hpp`. Quan pugeu la vostra
solució al jutge, només cal que pugeu un `tar` construït així:

    tar cf solution.tar evaluate.cpp

## Entrada

L'entrada té una seqüència de casos, on cada cas té una primera linia
amb una descripció dels valors de les variables (una seqüència de
parelles $<$variable,valor$>$), i una segona linia amb una instrucció
del llenguatge. Fixeu-vos en que el programa que us oferim ja
s'encarrega de llegir aquesta entrada. Només cal que implementeu la
funció abans esmentada.

## Sortida

Per a cada cas, la sortida té una linia amb la corresponent avaluació de
l'arbre. Fixeu-vos en que el programa que us oferim ja s'encarrega
d'escriure aquesta avaluació. Només cal que implementeu la funció abans
esmentada.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T21:22:00.961Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
