# Classe diccionari (I)

Cal implementar la següent classe $dicc$ que ens permet representar i
manipular diccionaris, on les claus que identifiquen els elements són
del tipus $Clau$ que admet una relació d'ordre total, és a dir, tenim
una operació de comparació $<$ entre claus:

    #include <iostream>
    using namespace std;

    template <typename Clau>
    class dicc {

    public:
        // Constructora per defecte. Crea un diccionari buit.
        dicc();

        // Les tres grans: Constructora per còpia, destructora, operador d’assignació
        dicc(const dicc &d);
        ~dicc();
        dicc& operator=(const dicc &d);

        // Insereix la clau k en el diccionari. Si ja hi era, no fa res.
        void insereix(const Clau &k);

        // Elimina la clau k del diccionari. Si no hi era, no fa res.
        void elimina(const Clau &k);

        // Consulta si la clau k està en el diccionari.
        bool consulta(const Clau &k) const;

        // Retorna quants elements (claus) té el diccionari.
        nat quants() const;

        // Impressió per cout de claus del diccionari en ordre ascendent, separades per
        //    un espai, començant per '[' i acabant per ']', en dues versions:
        // Imprimeix totes les claus
        void print() const;
        // Imprimeix les claus entre k1 i k2 ambdós incloses. Pre: $k1 <= k2$
        void print_interval(const Clau &k1, const Clau &k2) const;

        // Retorna la clau més petita i la més gran respectivament.
        // Pre: El diccionari no està buit
        Clau min() const;
        Clau max() const;

        // Retorna la clau de la posició i-èssima (comptant-les en ordre ascendent).
        // Pre: El diccionari no està buit. $1 <= i <= quants()$
        Clau iessim(nat i) const;

    private:
      // Aquí van els atributs i mètodes privats
    };

    // Aquí va la implementació dels mètodes públics i privats

Bàsicament el que cal fer és:

1.  Trobar una representació adequada pels objectes de la classe i
    escriure els atributs necessaris en la part $private$.

2.  Implementar tots els mètodes de la classe els quals manipularan la
    representació anterior.

Degut a que jutge.org només permet l'enviament d'un fitxer amb la
solució del problema, en el mateix fitxer hi ha d'haver l'especificació
i l'implementació de la classe (el que normalment estarien separats en
els fitxers $.hpp$ i $.cpp$).

Per testejar la classe disposeu d'un programa principal que processa
blocs que contenen un diccionari amb claus enteres i vàries comandes que
el manipula.

## Entrada

L'entrada conté varis blocs separats per línies amb 10 guions
(-----------). Cada bloc consisteix en una línia que conté una
seqüències d'enters, són els elements que tindrà originalment el
diccionari. A continuació segueixen vàries comandes, una per línea, amb
el següent format (k, k1 i k2 són claus enteres; i és un natural major
que 0):

- insereix k

- elimina k

- consulta k

- quants

- print

- print_interval k1 k2

- min

- max

- iessim i

## Sortida

Per a cada línia d'entrada, escriu una línia amb el resultat:

- Si la línia és un diccionari, mostra el diccionari un cop inserit tots
  els seus elements.

- Si la línia és una comanda, mostra la comanda, el separador \": \" i
  el resultat. Si la comanda modifica el diccionari, mostra quants
  elements té desprès d'aplicar-la.

- Si la línia és el separador de blocs format per 10 guions, mostra els
  mateixos 10 guions.

## Observació

Només cal enviar les classes requerides; el programa principal serà
ignorat. Seguiu estrictament la definició dels tipus de l'enunciat.

Per implementar el diccionari no es poden usar les classes $stack$,
$queue$, $list$, $set$ o $map$ de la STL.

Els mètodes insereix, elimina, consulta, min, max i iessim almenys han
de tenir cost logarítmic (en el cas mig) per superar els jocs de prova
privats. El mètode quants ha de tenir cost constant i els mètodes print
i print_interval cost lineal.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T17:44:10.123Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
