# TinyMicro ALU

Design the ALU of the TinyMicro. The ALU has two operands, `a` and `b`,
and one result `c`. The operation of the ALU is determined by the 2-bit
control signals `Op` as follows:

- `Op`=00, $c=a+b$.

- `Op`=01, $c=a-b$.

- `Op`=10, $c=b-a$.

- `Op`=11, $c=a$.

Design a parametrized $N$-bit ALU with a default value of $N=8$.

## Specification

``` verilog
module ALU(a, b, Op, c);
    parameter N=8;
    input [N-1:0] a, b;
    input [1:0] Op;
    output [N-1:0] c;
```

## Input

- `a` and `b` are the two input operands.

- `Op` indicates the type of operation.

## Output

- `c` is the result of the operation.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:25:01.421Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
