# Parelles de punts consecutius que estan a prop

En aquest exercici us donem un programa que heu de completar. Al
principi del programa es defineix un struct `Point`, que defineix un
punt sobre el pla 2D amb coordenades enteres. El programa principal
llegeix varis casos d'entrada. Cada cas consisteix en la descripció
d'una llista de punts. Per a cada cas, el programa principal crida a una
funció anomenada `compute` que és l'única que heu d'implementar (no heu
de canviar res més). La funció `compute` rep la llista de punts com a
paràmetre, i també rep un paràmetre enter `distance`, i retorna el
nombre de parelles de punts que apareixen consecutivament a la llista, i
tals que la distància (eucliciana) entre ells és menor o igual a
`distance`.

Aquest és el codi que heu de completar:

    #include <iostream>
    #include <string>
    #include <vector>

    using namespace std;

    struct Point {
        int x, y;
    };

    typedef vector<Point> VPoint;

    // Afegiu funcions auxiliars si voleu.
    // ...


    // Pre:  v conté com a mínim un punt.
    //       d >= 1
    // Post: Retorna el nombre de parelles de punts que apareixen consecutivament a v,
    //       i tals que la distància entre ells és menor o igual a d.
    int compute(VPoint &v, int distance)
    {
        // Implementeu aquesta funció.
        // ...
    }

    int main()
    {
        int n, d;
        while (cin >> n >> d) {
            VPoint v(n);
            for (int i = 0; i < n; i++)
                cin >> v[i].x >> v[i].y;
            cout << compute(v, d) << endl;
        }
    }

## Entrada

L'entrada té varis casos. Cada cas comença amb dos naturals positius
$n,distance$ majors o iguals a 1 en una primera línia. En una segona
línia hi ha la descripció d'una llista d'$n$ punts, amb les seves dues
coordenades x,y (enteres). De fet, no us heu de preocupar massa per com
son aquestes entrades perquè el programa que us donem ja té la part de
lectura implementada. Només us heu de preocupar d'implementar la funció
`compute` abans esmentada.

## Sortida

Per a cada cas, el programa ha d'escriure en una nova línia el
corresponent nombre de parelles de punts consecutius a la llista tals
que la distància entre ells és menor o igual a `distance`.De fet, no us
heu de preocupar massa per com son aquestes sortides perquè el programa
que us donem ja té la part d'escriptura implementada. Només us heu de
preocupar d'implementar la funció `compute` abans esmentada.

## Observació

Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost lineal i capaç
de superar els jocs de proves públics i privats. Entenem com a solució
lenta una que no és ràpida, però és correcta i capaç de superar els jocs
de proves públics.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T17:38:54.070Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
