# TinyMicro control unit

Design the control unit of the TinyMicro.

## Specification

``` verilog
module control_unit (Instruction, Instruction_Address, EnA, EnB, Op,
                     ReadWrite, MemConst, MemALU, Zero, Positive, Const,
                     clk, rst);
    input [7:0] Instruction;
    output [5:0] Instruction_Address;
    output [1:0] Op;
    output [7:0] Const;
    output EnA, EnB, ReadWrite, MemConst, MemALU;
    input Zero, Positive;
    input clk, rst;
```

## Input

- `Instruction` is the instruction coming from the instruction memory.

- `Zero` is the signal that is asserted when the *zero* condition for a
  jump is true.

- `Positive` is the signal that is asserted when the *positive*
  condition for a jump is true.

- `clk` is the clock signal of the circuit.

- `rst` is the reset signal of the circuit.

## Output

- `Instruction_Address` is the address sent to the instruction memory
  (program counter).

- `Op` indicates the type of operation for ALU instructions.

- `Const` is the constant encoded in instruction register (sign-extended
  up to 8 bits).

- `EnA` and `EnB` are the signals that enable writing into registers RA
  ad RB, respectively.

- `ReadWrite` is the signal the indicates whether to read (0) from or
  write (1) into data memory.

- `MemConst` is the signal that controls the datapath multiplexer
  selecting between data memory (0) and constant from the instruction
  register (1).

- `MemALU` is the signal that controls the datapath multiplexer
  selecting between memory/constant (0) and the ALU output (1).

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:25:15.001Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
