# Següent Binari

Els **números binaris** són números tals que les xifres són, únicament,
zeros i uns. Tècnicament, diem que són números en **base 2**, és a dir,
que només tenim dues xifres. Els numeros que normalment fem servir
nosaltres són en **base 10**, perquè tenen 10 dígits:
$0,1,2,3,4,5,6,7,8,9$. Apart d'aquesta peculiaritat, els números binaris
es comporten com els números en base $10$.

Per exemple, una seqüència de nombres binaris seria:

                 0 , 1, 
                 10, 11, 
                 100, 101, 110, 111, 
                 1000, 1001, 1010, 1011,
                 1100,  1101, 1110, 1111, 
                 10000, ...

Ara ens fixem en els binaris d'una mida determinada, per exemple, els de
mida $m = 3$, és a dir, els que tenen, **com a màxim**, $3$ dígits.
Serien, com hem vist: $0,1,10,11,100,101,110,111$.

Cal que feu una funció `seguent_binari(V)` tal que, donat un vector `V`
de mida $1 \leq m$, que conté només zeros i uns, que són la
representació d'un número binari, torni un **vector** que representa el
**següent** número binari.

Per exemple, si `V = [1, 0, 1]`, la funció ha de tornar `V = [1, 1, 0]`.
Cal tenir en compte que el següent de `V = [1, 1, 1]` és
`V = [0, 0, 0]`.

**Pista**: només cal que trobeu la manera que teniu vosaltres de
calcular el següent nombre decimal, dígit a dígit. El mateix algoritme
(més senzill) el podeu aplicar a aquest cas.

## Entrada

Un vector `V` de zeros i uns, de mida $1 \leq m$, que representa un
nombre binari.

## Sortida

Un vector de mida $m$ que representa el **següent** nombre binari de
`V`. En cas que `V` fos el darrer nombre binari de mida $m$, llavors cal
tornar el primer binari de mida $m$, és a dir, un vector amb $m$ zeros.

## Informació del problema

Autoria: Jaume Baixeries

Generació: 2026-01-25T18:26:26.038Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
