# Més combinacions en Esperanto (II)

L'Esperanto és una llengua *artificial* és a dir, creada de manera
expressa per humans, en contrast amb les altres llengües que s'anomenen
*naturals*, com per exemple, el català. Va ser creada pel oftalmòleg
jueu polonès **Ludwik Lejzer Zamenhof**. La seva intenció era crear una
llengua que no fos de ningú i que, alhora, pogués ser de tothom qui ho
volgués, facilitant així l'entesa entre parlants de llengües diferents.
Pretenia que no fos un dels dos parlants qui hagués de cedir cap a
l'altra llengua, sinó que tots dos haguessin de cedir i fer servir
aquesta llengua *auxiliar*.

L'Esperanto té 16 regles gramaticals, i en aquesta pràctica en farem
servir tres:

1.  Els *pronoms personals* (independentment del gènere) acaben en la
    lletra **-i**. Per exemple, **mi** (jo), o **li** (ell).

2.  Els *verbs* en present d'indicatiu (independentment del subjecte)
    acaben en **-as**. Per exemple, **legas**
    (llegeixo/llegeixes/llegeix/llegim/llegiu/llegeixen), o **pensas**
    (penso/penses/pensa/pensem/penseu/pensen).

3.  Els *complements directes* acaben en la lletra **-n**. Això es fa
    afegint la lletra **-n** a qualsevol paraula. Per exemple, **libro**
    (llibre) $\rightarrow$ **libron**, o **tempo** (temps) $\rightarrow$
    **tempon**.

La pràctica consisteix en **tres exercicis** que cal fer de manera
**acumulativa**. Això vol dir que per a fer aquesta segona part caldrà
fer servir el que hagueu fet (si funciona bé) a la primera part.

# Segona Part

La **segona part** consisteix a fer una funció que, donats dues llistes
`PRONOMS` i `VERBS` formi totes les possibles combinacions de *pronom* i
*verb* (separats per un espai). Concretament, la funció serà aquesta:

`calculaParelles(PRONOMS,VERBS)`

- `PRONOMS` és una llista que conté paraules que acaben en la lletra
  **i**. `VERBS` és una llista que conté paraules que acaben en la
  lletra **s**.

- Torna una llista amb totes les combinacions que es pot fer
  `pronom verb`, separats per un espai.

Per exemple, si `PRONOMS = ['mi','ni']` i `VERBS = ['pensas', 'legas']`,
el resultat hauria de ser la llista

`R = ['mi pensas', 'mi legas', 'ni pensas', 'ni legas']`.

Com es pot observar, l'ordre de les combinacions ha de respectar l'ordre
que hi ha en les llistes `PRONOMS` i `VERBS`.

Recordeu que podeu concatenar `strings` fent servir l'operador de suma.
Per exemple, `"mi" + " "  + "pensas"` avalua a `"mi pensas"`.

## Observació

Només has d'enviar el fitxer amb la funció (i les funcions auxiliars que
hagis fet) que et demanem i prou. El fitxer `main.py` et pot servir per
provar la teva solució, però en cap cas has d'enviar el seu contingut.

## Entrada

paraula1 paraula2 \...

acabada en la paraula FINO

## Sortida

Tres llistes que contenen els pronoms personals (acabats en *i*), els
verbs (acabats en *s*) i els objectes (acabats en *n*) del canal
d'entrada.

Donades les llistes de pronoms i verbs, genera totes les parelles
*pronom verb*.

## Informació del problema

Autoria: INFO EPSEVG

Generació: 2026-01-25T19:14:29.944Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
