# Legible Words

In computer science we often consider *words* made of letters. Usually
these are arbitrary strings of letters, but in practice, not all of such
words would be legible (for example, it is hard to pronounce
*bcabcbca*).

It is hard to define whether a word is legible. In this problem, we
assume that a word is legible iff there are no three consecutive
consonants.

Your task is to calculate the number of legible words of given length,
using the given letters.

## Input

Input consists of several cases. Each case consists of three numbers:
$C$ (the number of considered consonants), $V$ (the number of considered
vowels), $N$ (the length of the words to consider). We have
$1 \leq C \leq 50$, $1 \leq V \leq 50$, $1 \leq N \leq 100$.

After the last case the input contains a line containing 0 0 0.

## Output

Output the number of legible words. It is guaranteed that it will never
be greater than $10^{18}$.

We have three consonants and two wovels, say, $a$, $b$, $c$, $d$, $e$.
According to our definition, there are 5 words of length 1 (all
letters), and 25 words of length 2 (all possible pairs of letters). At
length 3 the answer is 98 (out of $5^3$ possible words, $3^3$ consists
of only wovels, which makes them illegible).

## Problem information

Author: Eryk Kopczynski

Generation: 2026-01-25T22:01:11.914Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
