# Cubeta

Consideremos una lavadora y una cubeta de ropa para lavar. Su operativa
normal permite depositar una prenda de ropa tanto en la lavadora como en
la cubeta. También existe la posibilidad de completar la lavadora con
ropa de la cubeta.

Una lavadora puede estar inicializada o no. Todas las operaciones con
lavadoras, salvo la inicialización y la escritura, solamente se pueden
aplicar sobre lavadoras inicializadas. Los datos relevantes para
inicializar una lavadora son el peso máximo que se pretende cargar en
ella y si va a ser de ropa blanca o de color. Las prendas de ropa
también tienen como atributos su peso y su color. Todos los pesos serán
números naturales y la información del color puede representarse con un
booleano (por ejemplo, el blanco mediante el valor `false` y el color
con el valor `true`).

Cuando se desea completar una lavadora, se extrae de la cubeta la mayor
cantidad posible de ropa del tipo correspondiente (blanco o color) que
no se pase del peso máximo de la lavadora y sacando primero las prendas
de ropa introducidas en último lugar.

Por último, se dispone de una operación que simula el lavado de las
prendas que se encuentren en la lavadora en un momento dado. Se podrá
aplicar incluso si la lavadora no está llena. Su resultado es que la
lavadora queda no operativa y lista para inicializarse con nuevos datos.

El programa principal creará (o, mejor dicho, instalará) la cubeta y la
lavadora y se encargará de aplicar las operaciones descritas, ofreciendo
un menú de opciones:

    Esquema de programa principal:
     
      instalar lavadora
      instalar cubeta
      leer opción
      while (opcion != -8) {    
        if (opcion == -1) // inicializar lavadora (datos: peso máximo y color)
        else if (opcion == -2) // añadir una prenda a la lavadora (datos: peso  y color de la prenda)
        else if (opcion == -3) // añadir una prenda a la cubeta (datos: peso  y color de la prenda)
        else if (opcion == -4) // completar la lavadora
        else if (opcion == -5) // realizar un lavado
        else if (opcion == -6) // escribir el contenido de la cubeta
        else if (opcion == -7) // escribir el contenido de la lavadora
        leer opción
      }

Por último, podéis suponer que los datos de la entrada son correctos. Si
no lo fueran, habría que aplicar las protecciones correspondientes a las
operaciones antes de utilizarlas, para garantizar que se cumplen sus
precondiciones.

## Entrada

Una colección de instrucciones de las disponibles en el programa
principal

## Salida

Las salidas de las correspondientes instrucciones.

## Observación

Se han especificado las clases `Cubeta, Lavadora y Prenda` y los
correspondientes ficheros `.hh` se pueden descargar del icono del
gatito. También se pueden descargar algunos ficheros de utilidades.

Hay que enviar 5 ficheros en un solo .tar.

- `Cubeta.cc, Lavadora.cc y Prenda.cc` con las implementaciones de las
  correspondientes clases.

- `Makefile`, para compilar y obtener el ejecutable

- `program.cc`, el programa principal

## Información del problema

Autoría: Juan Luis Esteban, Borja Valles

Generación: 2026-01-25T21:20:12.204Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
