# Greatest Common Divisor

Design a circuit that calculates the greatest common divisor of two
positive 4-bit numbers (the values must be between 1 and 15). The
circuit must be initialized by asserting the `rst` signal. After that,
the circuit is ready to receive a 1-cycle pulse of signal `start`,
indicating that the inputs are valid and the calculation can start. When
the gcd has been computed, the circuit must generate a 1-cycle pulse on
signal `done`, indicating that output `g` has the result on that cycle.
The following waveform illustrates the behavior of the circuit.

::: center
![image](waveform.png){width="12cm"}
:::

For the circuit to be correct, it must calculate the gcd in the minimum
number of steps of Euclid's algorithm using subtraction. For example,
for the inputs 15 and 6, the `done` signal must be asserted three cycles
after reading the inputs, as shown in the figure:

$$(15,6)\stackrel{1}{\longrightarrow}
(9,6)\stackrel{2}{\longrightarrow}
(3,6)\stackrel{3}{\longrightarrow}
(3,3).$$

## Specification

``` verilog
module gcd(a, b, g, start, done, clk, rst);
    input [3:0] a, b;
    output [3:0] g;
    input clk, rst;
    input start;
    output done;
```

## Input

- `a` and `b` are the two input numbers.

- `start` is the signal that indicates the start of the computation.

- `clk` is the clock signal.

- `rst` is the synchronous reset signal.

## Output

- `g` is the gcd of the two input numbers.

- `done` indicates when the computation is completed (`g` is valid).

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:22:43.792Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
